/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.servlet.handler;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.Handler;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;

public class ChannelCacheHandler
implements Handler {
    private final ReadableChannel channel;
    private final MetaKey key;

    public ChannelCacheHandler(ReadableChannel channel, MetaKey key) {
        this.channel = channel;
        this.key = key;
    }

    @Override
    public void process(OutputStream stream) throws IOException {
        this.channel.streamCacheEntry(this.key, entry -> {
            long l = ByteStreams.copy((InputStream)entry.getStream(), (OutputStream)stream);
        });
    }

    @Override
    public void process(HttpServletResponse response) throws IOException {
        if (!this.channel.streamCacheEntry(this.key, entry -> {
            response.setContentType(entry.getMimeType());
            response.setContentLengthLong(entry.getSize());
            ByteStreams.copy((InputStream)entry.getStream(), (OutputStream)response.getOutputStream());
        })) {
            response.setStatus(404);
            response.getWriter().format("Content '%s' not found.%n", this.key);
        }
    }
}

