/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.provider.security.impl;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import com.eclipsesource.jaxrs.provider.security.impl.ContainerRequestFilterImpl;
import com.eclipsesource.jaxrs.provider.security.impl.RolesAllowedDynamicFeatureImpl;
import com.eclipsesource.jaxrs.provider.security.impl.SecurityAdmin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator instance;
    private ServiceTracker authenticationHandlerTracker;
    private ServiceTracker authorizationHandlerTracker;
    private ServiceRegistration rolesAllowedDynamicFeatureRegistration;
    private ServiceRegistration containerRequestFilterRegistration;

    public static Activator getInstance() {
        return instance;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return (AuthenticationHandler)this.authenticationHandlerTracker.getService();
    }

    public AuthorizationHandler getAuthorizationHandler() {
        return (AuthorizationHandler)this.authorizationHandlerTracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        this.registerProviderServices(context);
        this.createHandlerTrackers(context);
        instance = this;
    }

    private void registerProviderServices(BundleContext context) {
        this.rolesAllowedDynamicFeatureRegistration = context.registerService(RolesAllowedDynamicFeatureImpl.class.getName(), (Object)new RolesAllowedDynamicFeatureImpl(), null);
        this.containerRequestFilterRegistration = context.registerService(ContainerRequestFilterImpl.class.getName(), (Object)new ContainerRequestFilterImpl(new SecurityAdmin()), null);
    }

    private void createHandlerTrackers(BundleContext context) {
        this.authenticationHandlerTracker = new ServiceTracker(context, AuthenticationHandler.class.getName(), null);
        this.authenticationHandlerTracker.open();
        this.authorizationHandlerTracker = new ServiceTracker(context, AuthorizationHandler.class.getName(), null);
        this.authorizationHandlerTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.unregisterProviderServices();
        this.closeHandlerTrackers();
    }

    private void unregisterProviderServices() {
        if (this.rolesAllowedDynamicFeatureRegistration != null) {
            this.rolesAllowedDynamicFeatureRegistration.unregister();
        }
        if (this.containerRequestFilterRegistration != null) {
            this.containerRequestFilterRegistration.unregister();
        }
    }

    private void closeHandlerTrackers() {
        if (this.authenticationHandlerTracker != null) {
            this.authenticationHandlerTracker.close();
        }
        if (this.authorizationHandlerTracker != null) {
            this.authorizationHandlerTracker.close();
        }
    }

    static void setInstance(Activator activator) {
        instance = activator;
    }
}

