/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;
import org.eclipse.packagedrone.utils.gson.InstantTypeAdapter;

public abstract class AbstractSimpleGsonStorageModelProvider<V, W, G>
extends AbstractSimpleStorageModelProvider<V, W> {
    protected final Class<G> gsonModelClass;

    public AbstractSimpleGsonStorageModelProvider(Class<W> writeClazz, Class<G> gsonModelClass) {
        super(writeClazz);
        this.gsonModelClass = gsonModelClass;
    }

    @Override
    protected void persistWriteModel(StorageContext context, W writeModel) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(this.makePath(context), StandardCharsets.UTF_8);){
            this.createGson().toJson(this.toGsonModel(writeModel), (Appendable)writer);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected abstract G toGsonModel(W var1);

    protected abstract W fromGsonModel(G var1);

    protected Gson createGson() {
        GsonBuilder gb = new GsonBuilder();
        gb.setPrettyPrinting();
        gb.registerTypeAdapter(Instant.class, (Object)InstantTypeAdapter.DEFAULT_INSTANCE);
        return gb.create();
    }

    @Override
    protected W loadWriteModel(StorageContext context) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.makePath(context));){
                return this.fromGsonModel(this.createGson().fromJson((Reader)reader, this.gsonModelClass));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return this.createNewModel();
        }
    }

    protected abstract W createNewModel();

    protected abstract Path makePath(StorageContext var1);
}

