/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.trigger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.packagedrone.repo.trigger.TriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessorConfiguration;

public class TriggeredChannelModel {
    private final Map<String, List<TriggerProcessorConfiguration>> processors = new HashMap<String, List<TriggerProcessorConfiguration>>();
    private final Map<String, TriggerConfiguration> triggers = new HashMap<String, TriggerConfiguration>();

    public void addProcessor(String triggerId, TriggerProcessorConfiguration value) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(value);
        List<TriggerProcessorConfiguration> trigger = this.processors.get(triggerId);
        if (trigger == null) {
            trigger = new ArrayList<TriggerProcessorConfiguration>();
            this.processors.put(triggerId, trigger);
        } else if (trigger.stream().anyMatch(cfg -> cfg.getId().equals(value.getId()))) {
            throw new IllegalArgumentException(String.format("Processor entry with ID '%s' already exists for trigger '%s'", value.getId(), triggerId));
        }
        trigger.add(value);
    }

    public void modifyProcessor(String triggerId, String processorId, String configuration) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(processorId);
        List<TriggerProcessorConfiguration> trigger = this.processors.get(triggerId);
        if (trigger == null) {
            throw new UnknownProcessorException(triggerId, processorId);
        }
        ListIterator<TriggerProcessorConfiguration> i = trigger.listIterator();
        while (i.hasNext()) {
            TriggerProcessorConfiguration cfg = i.next();
            if (!cfg.getId().equals(processorId)) continue;
            i.set(new TriggerProcessorConfiguration(processorId, cfg.getFactoryId(), configuration));
            return;
        }
        throw new UnknownProcessorException(triggerId, processorId);
    }

    public void deleteProcessor(String triggerId, String processorId) {
        List<TriggerProcessorConfiguration> trigger = this.processors.get(triggerId);
        if (trigger == null) {
            return;
        }
        trigger.removeIf(cfg -> cfg.getId().equals(processorId));
        if (trigger.isEmpty()) {
            this.processors.remove(triggerId);
        }
    }

    public Set<String> getTriggers() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.processors.keySet());
        result.addAll(this.triggers.keySet());
        return result;
    }

    public Map<String, TriggerConfiguration> getConfiguredTriggers() {
        return this.triggers;
    }

    public List<TriggerProcessorConfiguration> getProcessors(String triggerId) {
        List<TriggerProcessorConfiguration> trigger = this.processors.get(triggerId);
        if (trigger == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(trigger);
    }

    public void addTrigger(String triggerId, TriggerConfiguration triggerConfiguration) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(triggerConfiguration);
        if (this.triggers.containsKey(triggerId)) {
            throw new IllegalStateException(String.format("Trigger '%s' already exists for this channel", triggerId));
        }
        this.triggers.put(triggerId, triggerConfiguration);
    }

    public void modifyTrigger(String triggerId, String configuration) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(configuration);
        TriggerConfiguration trigger = this.triggers.get(triggerId);
        if (trigger == null) {
            throw new IllegalStateException(String.format("Trigger '%s' does not exist on this channel", triggerId));
        }
        this.triggers.put(triggerId, new TriggerConfiguration(trigger.getTriggerFactoryId(), configuration));
    }

    public void deleteTrigger(String triggerId) {
        this.triggers.remove(triggerId);
    }

    public Optional<TriggerConfiguration> getTriggerConfiguration(String triggerId) {
        return Optional.ofNullable(this.triggers.get(triggerId));
    }

    public void reorderProcessors(String triggerId, String processorId1, String processorId2) {
        int p2;
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(processorId1);
        List<TriggerProcessorConfiguration> list = this.processors.get(triggerId);
        if (list == null) {
            throw new IllegalArgumentException(String.format("Unknow trigger '%s'", triggerId));
        }
        int p1 = Iterables.indexOf(list, e -> e.getId().equals(processorId1));
        int n = p2 = processorId2 != null ? Iterables.indexOf(list, e -> e.getId().equals(processorId2)) : 0;
        if (p1 < 0) {
            throw new IllegalArgumentException(String.format("Unknown processor '%s' for trigger '%s'", processorId1, triggerId));
        }
        if (p2 < 0) {
            throw new IllegalArgumentException(String.format("Unknown processor '%s' for trigger '%s'", processorId2, triggerId));
        }
        TriggerProcessorConfiguration t1 = list.remove(p1);
        if (processorId2 != null) {
            list.add(p2, t1);
        } else {
            list.add(t1);
        }
    }

    public void moveProcessor(String triggerId1, String processorId1, String triggerId2, String processorId2) {
        int p2;
        Objects.requireNonNull(triggerId1);
        Objects.requireNonNull(triggerId2);
        Objects.requireNonNull(processorId1);
        List<TriggerProcessorConfiguration> list1 = this.processors.get(triggerId1);
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Unknow trigger '%s'", triggerId1));
        }
        List<TriggerProcessorConfiguration> list2 = this.processors.get(triggerId2);
        if (list2 == null) {
            if (processorId2 != null) {
                throw new IllegalArgumentException(String.format("Unknow trigger '%s'", triggerId2));
            }
            list2 = new LinkedList<TriggerProcessorConfiguration>();
            this.processors.put(triggerId2, list2);
        }
        int p1 = Iterables.indexOf(list1, e -> e.getId().equals(processorId1));
        int n = p2 = processorId2 != null ? Iterables.indexOf(list2, e -> e.getId().equals(processorId2)) : 0;
        if (p1 < 0) {
            throw new IllegalArgumentException(String.format("Unknown processor '%s' for trigger '%s'", processorId1, triggerId1));
        }
        if (p2 < 0) {
            throw new IllegalArgumentException(String.format("Unknown processor '%s' for trigger '%s'", processorId2, triggerId2));
        }
        TriggerProcessorConfiguration t1 = list1.remove(p1);
        if (processorId2 != null) {
            list2.add(p2, t1);
        } else {
            list2.add(t1);
        }
    }

    public static class UnknownProcessorException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public UnknownProcessorException(String triggerId, String processorId) {
            super(String.format("There is no processor '%s' for trigger '%s'", processorId, triggerId));
        }
    }
}

