/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.http.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.repo.importer.http.Configuration;
import org.eclipse.packagedrone.repo.importer.http.web.TestResult;
import org.eclipse.packagedrone.repo.importer.web.ImportRequest;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ConfigurationController {
    private final Gson gson = new GsonBuilder().create();
    private JobManager jobManager;

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @RequestMapping(value={"/import/{token}/http/start"}, method={RequestMethod.GET})
    public ModelAndView configure(@RequestParameter(value="configuration", required=false) Configuration cfg) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (cfg != null) {
            model.put("command", cfg);
        } else {
            model.put("command", new Configuration());
        }
        model.put("ok", Boolean.FALSE);
        return new ModelAndView("configure", model);
    }

    @RequestMapping(value={"/import/{token}/http/start"}, method={RequestMethod.POST})
    public ModelAndView configurePost(@Valid @FormData(value="command") Configuration data, BindingResult result) {
        HashMap<String, Boolean> model = new HashMap<String, Boolean>();
        model.put("ok", !result.hasErrors());
        return new ModelAndView("configure", model);
    }

    @RequestMapping(value={"/import/{token}/http/test"}, method={RequestMethod.POST})
    public ModelAndView testImport(@Valid @FormData(value="command") Configuration data, BindingResult result, HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("command", data);
        JobHandle job = this.jobManager.startJob("org.eclipse.packagedrone.repo.importer.http.web.tester", (Object)data);
        model.put("job", job);
        return new ModelAndView("test", model);
    }

    @RequestMapping(value={"/import/{token}/http/testComplete"}, method={RequestMethod.POST})
    public ModelAndView completeTest(@RequestParameter(value="jobId") String jobId, @PathVariable(value="token") String token) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        JobHandle job = this.jobManager.getJob(jobId);
        if (job.isFailed()) {
            return new ModelAndView(String.format("redirect:/job/%s/result", jobId));
        }
        model.put("job", job);
        String data = job.getRequest().getData();
        Configuration cfg = (Configuration)this.gson.fromJson(data, Configuration.class);
        model.put("configuration", cfg);
        model.put("request", ImportRequest.toJson((String)"http", (String)data));
        model.put("cfgJson", job.getRequest().getData());
        model.put("result", TestResult.fromJson(job.getResult()));
        model.put("token", token);
        return new ModelAndView("testResult", model);
    }

    @ControllerValidator(formDataClass=Configuration.class)
    public void validateImport(Configuration cfg, ValidationContext ctx) {
        String url = cfg.getUrl();
        if (url == null || url.isEmpty()) {
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            ctx.error("url", "Only 'http' or 'https' URLs are supported");
        }
    }
}

