/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.web.channel.TreeTester;

public class TreeTesterImpl
implements TreeTester {
    private final Map<String, List<ArtifactInformation>> tree;
    private final Map<String, Severity> cache = new HashMap<String, Severity>();

    public TreeTesterImpl(Map<String, List<ArtifactInformation>> tree) {
        this.tree = tree;
    }

    @Override
    public Severity getState(ArtifactInformation artifact) {
        if (this.cache.containsKey(artifact.getId())) {
            return this.cache.get(artifact.getId());
        }
        Severity sev = this.evalSeverity(artifact);
        this.cache.put(artifact.getId(), sev);
        return sev;
    }

    private Severity evalSeverity(ArtifactInformation artifact) {
        Severity sev = artifact.getOverallValidationState();
        if (sev == Severity.ERROR) {
            return sev;
        }
        Severity childSev = this.getChildState(artifact);
        if (childSev == null) {
            return sev;
        }
        if (sev == null) {
            return childSev;
        }
        if (childSev.ordinal() > sev.ordinal()) {
            return childSev;
        }
        return sev;
    }

    private Severity getChildState(ArtifactInformation artifact) {
        List<ArtifactInformation> childs = this.tree.get(artifact.getId());
        if (childs == null) {
            return null;
        }
        Severity maxSev = null;
        for (ArtifactInformation child : childs) {
            Severity sev = this.getState(child);
            if (sev == Severity.ERROR) {
                return Severity.ERROR;
            }
            maxSev = sev;
        }
        return maxSev;
    }
}

