/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.todo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.packagedrone.repo.manage.todo.Task;
import org.eclipse.packagedrone.repo.manage.todo.TaskListener;
import org.eclipse.packagedrone.repo.manage.todo.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskProvider
implements TaskProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTaskProvider.class);
    private final Set<TaskListener> listeners = new HashSet<TaskListener>();
    private Set<Task> tasks = new CopyOnWriteArraySet<Task>();

    protected void fireNotify() {
        Collection<? extends Task> current = this.getTasks();
        for (TaskListener listener : this.listeners) {
            try {
                listener.tasksChanged(current);
            }
            catch (Exception e) {
                logger.warn("Failed to notify task change", (Throwable)e);
            }
        }
    }

    protected synchronized void addTask(Task task) {
        if (this.tasks.add(task)) {
            this.fireNotify();
        }
    }

    protected synchronized void removeTask(Task task) {
        if (this.tasks.remove(task)) {
            this.fireNotify();
        }
    }

    protected synchronized void setTasks(Collection<Task> tasks) {
        this.tasks = new CopyOnWriteArraySet<Task>(tasks);
        this.fireNotify();
    }

    @Override
    public synchronized Collection<? extends Task> getTasks() {
        return Collections.unmodifiableCollection(this.tasks);
    }

    @Override
    public synchronized void addListener(TaskListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(TaskListener listener) {
        this.listeners.remove(listener);
    }
}

