/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthentication.class);

    private BasicAuthentication() {
    }

    public static String[] parseAuthorization(HttpServletRequest request) {
        String auth = request.getHeader("Authorization");
        logger.debug("Auth header: {}", (Object)auth);
        if (auth == null || auth.isEmpty()) {
            return null;
        }
        String[] toks = auth.split("\\s");
        if (toks.length < 2) {
            return null;
        }
        if (!"Basic".equalsIgnoreCase(toks[0])) {
            return null;
        }
        byte[] authData = Base64.getDecoder().decode(toks[1]);
        String authStr = StandardCharsets.ISO_8859_1.decode(ByteBuffer.wrap(authData)).toString();
        logger.debug("Auth String: {}", (Object)authStr);
        String[] authToks = authStr.split(":", 2);
        logger.debug("Auth tokens: {}", new Object[]{authToks});
        if (authToks.length != 2) {
            return null;
        }
        return authToks;
    }

    public static void request(HttpServletResponse response, String realm, String message) throws IOException {
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", realm));
        response.getWriter().write(message);
    }
}

