/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.RequestHandlerFactory;
import org.eclipse.packagedrone.web.controller.ControllerEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerTracker
implements RequestHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ControllerTracker.class);
    private final BundleContext context;
    private final ServiceListener listener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    ControllerTracker.this.handleAddingService(event.getServiceReference());
                    break;
                }
                case 4: {
                    ControllerTracker.this.handleRemovedService(event.getServiceReference());
                }
            }
        }
    };
    private final Map<ServiceReference<?>, ControllerEntry> controllers = new ConcurrentHashMap();

    public ControllerTracker(BundleContext context) {
        this.context = context;
        this.context.addServiceListener(this.listener);
        try {
            ServiceReference[] refs = context.getServiceReferences(null, null);
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.handleAddingService(ref);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    @Override
    public void close() {
        this.context.removeServiceListener(this.listener);
    }

    protected Object handleAddingService(ServiceReference<?> ref) {
        Object service = this.context.getService(ref);
        if (service != null && this.checkAddService(ref, service) == null) {
            this.context.ungetService(ref);
            service = null;
        }
        return service;
    }

    protected Object checkAddService(ServiceReference<?> ref, Object service) {
        logger.debug("Check add service - ref: {}", ref);
        Controller controller = service.getClass().getAnnotation(Controller.class);
        if (controller == null) {
            return null;
        }
        this.addController(ref, new ControllerEntry(service));
        return controller;
    }

    protected void addController(ServiceReference<?> ref, ControllerEntry entry) {
        logger.info("Added controller - {}", ref);
        this.controllers.put(ref, entry);
    }

    protected void handleRemovedService(ServiceReference<?> ref) {
        if (this.controllers.remove(ref) != null) {
            this.context.ungetService(ref);
        }
    }

    @Override
    public RequestHandler handleRequest(HttpServletRequest request, HttpServletResponse response) {
        for (ControllerEntry entry : this.controllers.values()) {
            RequestHandler result = entry.findHandler(request, response);
            if (logger.isTraceEnabled()) {
                logger.trace("Result from: {} -> {}", (Object)entry, (Object)result);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

