/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class InstantTypeAdapter
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    public static final InstantTypeAdapter DEFAULT_INSTANCE = new InstantTypeAdapter();
    private final DateTimeFormatter formatter;

    public InstantTypeAdapter(DateTimeFormatter formatter) {
        this.formatter = formatter.withLocale(Locale.US);
    }

    public InstantTypeAdapter() {
        this(DateTimeFormatter.ISO_INSTANT.withLocale(Locale.US));
    }

    public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("Timestamps should be encoded as JSON strings");
        }
        return Instant.from(this.formatter.parse(json.getAsString()));
    }

    public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }
}

