/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import org.eclipse.packagedrone.sec.CreateUser;
import org.eclipse.packagedrone.sec.DatabaseUserInformation;
import org.eclipse.packagedrone.sec.UserStorage;
import org.eclipse.packagedrone.sec.service.password.BadPasswordException;
import org.eclipse.packagedrone.sec.service.password.PasswordChecker;
import org.eclipse.packagedrone.sec.web.ui.NewPassword;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.MessageBindingError;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;

public class AbstractUserCreationController {
    protected UserStorage storage;
    protected PasswordChecker passwordChecker;

    public void setStorage(UserStorage storage) {
        this.storage = storage;
    }

    public void setPasswordChecker(PasswordChecker passwordChecker) {
        this.passwordChecker = passwordChecker;
    }

    @ControllerValidator(formDataClass=CreateUser.class)
    public void validateCreateUser(CreateUser createUser, ValidationContext context) {
        DatabaseUserInformation user = this.storage.getUserDetailsByEmail(createUser.getEmail());
        if (user != null) {
            context.error("email", "A user is already registered for this e-mail address");
            context.setMarker("duplicateEmail");
        }
        if (createUser.getPassword() != null && !createUser.getPassword().isEmpty()) {
            this.checkPassword(createUser.getPassword(), context);
        }
    }

    @ControllerValidator(formDataClass=NewPassword.class)
    public void validatePassword(NewPassword data, ValidationContext context) {
        this.checkPassword(data.getPassword(), context);
    }

    protected void checkPassword(String password, ValidationContext context) {
        try {
            this.passwordChecker.checkPassword(password);
        }
        catch (BadPasswordException e) {
            context.error("password", (BindingError)new MessageBindingError(e.getMessage()));
        }
    }
}

