/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.validation;

import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.validation.MessageInterpolator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class OsgiMessageInterpolator
implements MessageInterpolator {
    private MessageInterpolator fallback;
    private BundleTracker<Resolver> tracker;

    public OsgiMessageInterpolator(BundleContext context) {
        this.tracker = new BundleTracker(context, 36, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Resolver>(){

            public Resolver addingBundle(Bundle bundle, BundleEvent event) {
                if (bundle.getResource("META-INF/ValidationMessages.properties") != null) {
                    return new Resolver(bundle);
                }
                return null;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Resolver resolver) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Resolver resolver) {
                resolver.dispose();
            }
        });
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    public void setFallback(MessageInterpolator fallback) {
        this.fallback = fallback;
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        LinkedList<StringBuilder> keyStack = new LinkedList<StringBuilder>();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (escaped) {
                escaped = false;
                sb.append(c);
            } else {
                switch (c) {
                    case '\\': {
                        escaped = true;
                        break;
                    }
                    case '{': {
                        keyStack.push(new StringBuilder());
                        break;
                    }
                    case '}': {
                        try {
                            StringBuilder keySb = (StringBuilder)keyStack.pop();
                            sb.append(this.resolve(keySb.toString(), context, locale));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            sb.append('}');
                        }
                        break;
                    }
                    default: {
                        if (keyStack.isEmpty()) {
                            sb.append(c);
                            break;
                        }
                        ((StringBuilder)keyStack.peek()).append(c);
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected String resolve(String key, MessageInterpolator.Context context, Locale locale) {
        for (Resolver resolver : this.tracker.getTracked().values()) {
            String result = resolver.resolve(key, context, locale);
            if (result == null) continue;
            return result;
        }
        MessageInterpolator fallback = this.fallback;
        if (fallback == null) {
            return null;
        }
        return fallback.interpolate(String.format("{%s}", key), context, locale);
    }

    private static class Resolver {
        private final ClassLoader classLoader;

        public Resolver(Bundle bundle) {
            this.classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        }

        public String resolve(String name, MessageInterpolator.Context context, Locale locale) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("META-INF/ValidationMessages", locale != null ? locale : Locale.getDefault(), this.classLoader);
                return resourceBundle.getString(name);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }

        public void dispose() {
            ResourceBundle.clearCache(this.classLoader);
        }
    }
}

