/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether.web;

import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.packagedrone.job.AbstractJsonJobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.importer.aether.AetherImporter;
import org.eclipse.packagedrone.repo.importer.aether.ImportConfiguration;
import org.eclipse.packagedrone.repo.importer.aether.web.AetherResult;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherTester
extends AbstractJsonJobFactory<ImportConfiguration, AetherResult> {
    private static final Logger logger = LoggerFactory.getLogger(AetherTester.class);
    public static final String ID = "org.eclipse.packagedrone.repo.importer.aether.web.tester";
    private static final JobFactoryDescriptor DESCRIPTOR = new JobFactoryDescriptor(){

        public LinkTarget getResultTarget() {
            return null;
        }
    };

    public AetherTester() {
        super(ImportConfiguration.class);
    }

    protected String makeLabelFromData(ImportConfiguration data) {
        String label = "";
        if (!data.getCoordinates().isEmpty()) {
            label = data.getCoordinates().get(0).toString();
            if (data.getCoordinates().size() > 1) {
                label = String.valueOf(label) + String.format(" (and %s more)", data.getCoordinates().size() - 1);
            }
        }
        return String.format("Test Maven import: %s", label);
    }

    public JobFactoryDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    protected AetherResult process(JobInstance.Context context, ImportConfiguration cfg) throws Exception {
        Path tmpDir = Files.createTempDirectory("aether", new FileAttribute[0]);
        try {
            AetherResult aetherResult = AetherImporter.preparePlain(tmpDir, cfg);
            return aetherResult;
        }
        catch (Exception e) {
            logger.warn("Failed to test", (Throwable)e);
            throw e;
        }
        finally {
            Files.walkFileTree(tmpDir, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
            Files.deleteIfExists(tmpDir);
        }
    }
}

