/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import com.google.common.net.UrlEscapers;
import java.time.Instant;
import java.util.Optional;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.web.sitemap.ChangeFrequency;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapGenerator;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapIndexContext;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContext;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContextCreator;

public class ChannelSitemapGenerator
implements SitemapGenerator {
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void gatherRoots(SitemapIndexContext context) {
        context.addLocation("channels", this.calcLastMod());
    }

    public void render(String path, UrlSetContextCreator creator) {
        String[] toks = path.split("/");
        if (toks.length == 1 && "channels".equals(toks[0])) {
            UrlSetContext context = creator.createUrlSet();
            for (ChannelInformation ci : this.channelService.list()) {
                Optional<Instant> lastMod = Optional.ofNullable(ci.getState().getModificationTimestamp());
                String id = UrlEscapers.urlPathSegmentEscaper().escape(ci.getId());
                context.addLocation(String.format("/channel/%s/view", id), lastMod, Optional.of(ChangeFrequency.DAILY), Optional.empty());
                context.addLocation(String.format("/channel/%s/viewPlain", id), lastMod, Optional.of(ChangeFrequency.DAILY), Optional.empty());
                context.addLocation(String.format("/channel/%s/details", id), lastMod, Optional.of(ChangeFrequency.DAILY), Optional.empty());
                context.addLocation(String.format("/channel/%s/validation", id), lastMod, Optional.of(ChangeFrequency.DAILY), Optional.empty());
            }
        }
    }

    private Optional<Instant> calcLastMod() {
        Instant globalLastMod = null;
        for (ChannelInformation ci : this.channelService.list()) {
            Optional<Instant> lastMod = Optional.ofNullable(ci.getState().getModificationTimestamp());
            if (globalLastMod != null && !lastMod.get().isAfter(globalLastMod)) continue;
            globalLastMod = lastMod.get();
        }
        return Optional.ofNullable(globalLastMod);
    }
}

