/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import com.google.common.io.ByteStreams;
import com.google.common.net.UrlEscapers;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.validation.Valid;
import javax.xml.ws.Holder;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.aspect.recipe.RecipeInformation;
import org.eclipse.packagedrone.repo.aspect.recipe.RecipeNotFoundException;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.AspectableChannel;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelDetails;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.DeployKeysChannelAdapter;
import org.eclipse.packagedrone.repo.channel.DescriptorAdapter;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.VetoArtifactException;
import org.eclipse.packagedrone.repo.channel.deploy.DeployAuthService;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.repo.channel.web.Tags;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.channel.web.channel.AspectInformation;
import org.eclipse.packagedrone.repo.channel.web.channel.CreateChannel;
import org.eclipse.packagedrone.repo.channel.web.channel.EditChannel;
import org.eclipse.packagedrone.repo.channel.web.channel.TreeTesterImpl;
import org.eclipse.packagedrone.repo.channel.web.internal.Activator;
import org.eclipse.packagedrone.repo.generator.GeneratorProcessor;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.web.CommonCategories;
import org.eclipse.packagedrone.repo.web.sitemap.ChangeFrequency;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapExtender;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContext;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.page.Pagination;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.ProfilerControllerInterceptor;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class), @ControllerInterceptor(value=ProfilerControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ChannelController
implements InterfaceExtender,
SitemapExtender {
    private static final Comparator<ChannelListEntry> CHANNEL_LIST_ENTRY_COMPARATOR = Comparator.comparing(ChannelListEntry::getKey, Comparator.comparing(ChannelListEntryKey::getModifier).thenComparing(Comparator.comparing(ChannelListEntryKey::getId, String.CASE_INSENSITIVE_ORDER)));
    private static final int DEFAULT_MAX_WEB_SIZE = 10000;
    public static final String DRONE_WEB_MAX_LIST_SIZE = "drone.web.maxListSize";
    private static final String DEFAULT_EXAMPLE_KEY = "xxxxx";
    private static final Logger logger = LoggerFactory.getLogger(ChannelController.class);
    private static final List<MenuEntry> MENU_ENTRIES = Collections.singletonList(new MenuEntry("Channels", 100, new LinkTarget("/channel"), Modifier.DEFAULT, null));
    private static final Comparator<ArtifactInformation> TREE_ARTIFACTS_COMPARATOR = Comparator.comparing(ArtifactInformation::getName).thenComparing(ArtifactInformation::getCreationInstant);
    private DeployAuthService deployAuthService;
    private SitePrefixService sitePrefix;
    private ChannelService channelService;
    private final GeneratorProcessor generators = new GeneratorProcessor(FrameworkUtil.getBundle(ChannelController.class).getBundleContext());

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setDeployAuthService(DeployAuthService deployAuthService) {
        this.deployAuthService = deployAuthService;
    }

    public void setSitePrefixService(SitePrefixService sitePrefix) {
        this.sitePrefix = sitePrefix;
    }

    public void start() {
        this.generators.open();
    }

    public void stop() {
        this.generators.close();
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        return MENU_ENTRIES;
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView list(@RequestParameter(value="start", required=false) Integer startPage) {
        ModelAndView result = new ModelAndView("channel/list");
        List channels = this.channelService.list().stream().flatMap(ChannelController::toEntry).collect(Collectors.toList());
        channels.sort(CHANNEL_LIST_ENTRY_COMPARATOR);
        result.put("channels", (Object)Pagination.paginate((Integer)startPage, (int)10, channels));
        return result;
    }

    private static Stream<ChannelListEntry> toEntry(ChannelInformation info) {
        Stream<ChannelListEntry> idStream = Stream.of(ChannelController.fromChannel(info, Modifier.PRIMARY, info.getId(), "id"));
        Stream<ChannelListEntry> nameStream = info.getNames().stream().map(name -> ChannelController.fromChannel(info, Modifier.DEFAULT, name, "name"));
        return Stream.concat(idStream, nameStream);
    }

    private static ChannelListEntry fromChannel(ChannelInformation info, Modifier mod, String key, String by) {
        return new ChannelListEntry(new ChannelListEntryKey(mod, key, by), info);
    }

    @RequestMapping(value={"/channel/create"}, method={RequestMethod.GET})
    public ModelAndView create() {
        this.channelService.create("apm", new ChannelDetails(), Collections.emptyMap());
        return new ModelAndView("redirect:/channel");
    }

    @RequestMapping(value={"/channel/createDetailed"}, method={RequestMethod.GET})
    public ModelAndView createDetailed() {
        HashMap<String, CreateChannel> model = new HashMap<String, CreateChannel>(1);
        model.put("command", new CreateChannel());
        return new ModelAndView("channel/create", model);
    }

    @RequestMapping(value={"/channel/createDetailed"}, method={RequestMethod.POST})
    public ModelAndView createDetailedPost(@Valid @FormData(value="command") CreateChannel data, BindingResult result) {
        if (!result.hasErrors()) {
            ChannelDetails desc = new ChannelDetails();
            desc.setDescription(data.getDescription());
            ChannelId channel = this.channelService.create("apm", desc, Collections.emptyMap());
            this.setChannelNames(channel, ChannelController.splitChannelNames(data.getNames()));
            return new ModelAndView(String.format("redirect:/channel/%s/view", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId())));
        }
        return new ModelAndView("channel/create");
    }

    @RequestMapping(value={"/channel/createWithRecipe"}, method={RequestMethod.GET})
    public ModelAndView createWithRecipe() {
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("command", new CreateChannel());
        model.put("recipes", Activator.getRecipes().getSortedRecipes(RecipeInformation::getLabel));
        return new ModelAndView("channel/createWithRecipe", model);
    }

    private static Set<String> splitChannelNames(String names) {
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = names.split("[\\n\\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!(name = name.trim()).isEmpty()) {
                result.add(name);
            }
            ++n2;
        }
        return result;
    }

    private static String joinChannelNames(Collection<String> names) {
        return names.stream().collect(Collectors.joining("\n"));
    }

    @RequestMapping(value={"/channel/createWithRecipe"}, method={RequestMethod.POST})
    public ModelAndView createWithRecipePost(@Valid @FormData(value="command") CreateChannel data, @RequestParameter(required=false, value="recipe") String recipeId, BindingResult result) throws UnsupportedEncodingException, RecipeNotFoundException {
        if (!result.hasErrors()) {
            Holder holder = new Holder();
            Holder targetHolder = new Holder();
            if (recipeId == null || recipeId.isEmpty()) {
                ChannelDetails desc = new ChannelDetails();
                desc.setDescription(data.getDescription());
                holder.value = this.channelService.create("apm", desc, Collections.emptyMap());
                this.setChannelNames((ChannelId)holder.value, ChannelController.splitChannelNames(data.getNames()));
            } else {
                Activator.getRecipes().process(recipeId, recipe -> {
                    ChannelDetails desc = new ChannelDetails();
                    desc.setDescription(data.getDescription());
                    ChannelId channel = this.channelService.create("apm", desc, Collections.emptyMap());
                    this.setChannelNames(channel, ChannelController.splitChannelNames(data.getNames()));
                    this.channelService.accessRun(ChannelService.By.id((String)channel.getId()), AspectableChannel.class, aspChannel -> {
                        LinkTarget target = recipe.setup(channel.getId(), aspChannel);
                        if (target != null) {
                            HashMap<String, String> model = new HashMap<String, String>(1);
                            model.put("channelId", channel.getId());
                            holder.value = target.expand(model).getUrl();
                        }
                    });
                    holder2.value = channel;
                });
                if (targetHolder.value != null) {
                    return new ModelAndView("redirect:" + (String)targetHolder.value);
                }
            }
            return new ModelAndView(String.format("redirect:/channel/%s/view", URLEncoder.encode(((ChannelId)holder.value).getId(), "UTF-8")));
        }
        HashMap<String, List> model = new HashMap<String, List>(1);
        model.put("recipes", Activator.getRecipes().getSortedRecipes(RecipeInformation::getLabel));
        return new ModelAndView("channel/createWithRecipe", model);
    }

    protected void setChannelNames(ChannelId id, Collection<String> name) {
        this.channelService.accessRun(ChannelService.By.id((String)id.getId()), DescriptorAdapter.class, channel -> channel.setNames(name));
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/view"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView view(@PathVariable(value="channelId") String channelId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Optional channel = this.channelService.getState(ChannelService.By.name((String)channelId));
        if (channel.isPresent()) {
            return new ModelAndView(String.format("redirect:/channel/%s/view", ((ChannelInformation)channel.get()).getId()));
        }
        request.getRequestDispatcher("tree").forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/viewPlain"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView viewPlain(@PathVariable(value="channelId") String channelId) {
        try {
            return (ModelAndView)this.channelService.accessCall(ChannelService.By.id((String)channelId), ReadableChannel.class, channel -> {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("channel", channel.getInformation());
                Collection artifacts = channel.getContext().getArtifacts().values();
                if (artifacts.size() > this.maxWebListSize()) {
                    return this.viewTooMany((ReadableChannel)channel);
                }
                ArrayList sortedArtifacts = new ArrayList(artifacts);
                sortedArtifacts.sort(Comparator.comparing(ArtifactInformation::getName));
                model.put("sortedArtifacts", sortedArtifacts);
                return new ModelAndView("channel/view", model);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    private ModelAndView viewTooMany(ReadableChannel channel) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channel", channel.getInformation());
        model.put("numberOfArtifacts", channel.getArtifacts().size());
        model.put("maxNumberOfArtifacts", this.maxWebListSize());
        model.put("propertyName", DRONE_WEB_MAX_LIST_SIZE);
        return new ModelAndView("channel/viewTooMany", model);
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/tree"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView tree(@PathVariable(value="channelId") String channelId) {
        try {
            return (ModelAndView)this.channelService.accessCall(ChannelService.By.id((String)channelId), ReadableChannel.class, channel -> {
                if (channel.getContext().getArtifacts().size() > this.maxWebListSize()) {
                    return this.viewTooMany((ReadableChannel)channel);
                }
                ModelAndView result = new ModelAndView("channel/tree");
                HashMap<String, List<ArtifactInformation>> tree = new HashMap<String, List<ArtifactInformation>>();
                for (ArtifactInformation entry : channel.getContext().getArtifacts().values()) {
                    String parentId = entry.getParentId();
                    ArrayList<ArtifactInformation> list = (ArrayList<ArtifactInformation>)tree.get(parentId);
                    if (list == null) {
                        list = new ArrayList<ArtifactInformation>(parentId == null ? 1000 : 10);
                        tree.put(parentId, list);
                    }
                    list.add(entry);
                }
                for (List list : tree.values()) {
                    Collections.sort(list, TREE_ARTIFACTS_COMPARATOR);
                }
                result.put("channel", (Object)channel.getInformation());
                result.put("treeArtifacts", tree);
                result.put("treeSeverityTester", (Object)new TreeTesterImpl(tree));
                return result;
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    private Integer maxWebListSize() {
        return Integer.getInteger(DRONE_WEB_MAX_LIST_SIZE, 10000);
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/validation"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView viewValidation(@PathVariable(value="channelId") String channelId) {
        try {
            return (ModelAndView)this.channelService.accessCall(ChannelService.By.id((String)channelId), ReadableChannel.class, channel -> {
                ModelAndView result = new ModelAndView("channel/validation");
                result.put("channel", (Object)channel.getInformation());
                result.put("messages", (Object)channel.getInformation().getState().getValidationMessages());
                result.put("aspects", (Object)Activator.getAspects().getAspectInformations());
                return result;
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/details"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView details(@PathVariable(value="channelId") String channelId) {
        ModelAndView result = new ModelAndView("channel/details");
        try {
            this.channelService.accessRun(ChannelService.By.id((String)channelId), ReadableChannel.class, channel -> result.put("channel", (Object)channel.getInformation()));
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
        return result;
    }

    @RequestMapping(value={"/channel/{channelId}/delete"}, method={RequestMethod.GET})
    public ModelAndView delete(@PathVariable(value="channelId") String channelId) {
        ModelAndView result = new ModelAndView("redirect:/channel");
        if (this.channelService.delete(ChannelService.By.id((String)channelId))) {
            result.put("success", (Object)String.format("Deleted channel %s", channelId));
        } else {
            result.put("warning", (Object)String.format("Unable to delete channel %s. Was not found.", channelId));
        }
        return result;
    }

    @RequestMapping(value={"/channel/{channelId}/artifacts/{artifactId}/delete"}, method={RequestMethod.GET})
    public ModelAndView deleteArtifact(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return this.withChannel(channelId, ModifiableChannel.class, channel -> {
            channel.getContext().deleteArtifact(artifactId);
            return this.redirectDefaultView(channelId, true);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/artifacts/{artifactId}/get"}, method={RequestMethod.GET})
    public void getArtifact(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId, HttpServletResponse response) throws IOException {
        DownloadHelper.streamArtifact((HttpServletResponse)response, (ChannelService)this.channelService, (String)channelId, (String)artifactId, null, (boolean)true);
    }

    @RequestMapping(value={"/channel/{channelId}/artifacts/{artifactId}/dump"}, method={RequestMethod.GET})
    public void dumpArtifact(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId, HttpServletResponse response) throws IOException {
        DownloadHelper.streamArtifact((HttpServletResponse)response, (ChannelService)this.channelService, (String)channelId, (String)artifactId, null, (boolean)false);
    }

    @RequestMapping(value={"/channel/{channelId}/artifacts/{artifactId}/view"}, method={RequestMethod.GET})
    public ModelAndView viewArtifact(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            Optional artifact = channel.getArtifact(artifactId);
            if (!artifact.isPresent()) {
                return CommonController.createNotFound((String)"artifact", (String)artifactId);
            }
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("artifact", artifact.get());
            model.put("sortedMetaData", new TreeMap(((ChannelArtifactInformation)artifact.get()).getMetaData()));
            return new ModelAndView("artifact/view", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/add"}, method={RequestMethod.GET})
    public ModelAndView add(@PathVariable(value="channelId") String channelId) {
        ModelAndView mav = new ModelAndView("/channel/add");
        mav.put("generators", this.generators.getInformations().values());
        mav.put("channelId", (Object)channelId);
        return mav;
    }

    @RequestMapping(value={"/channel/{channelId}/add"}, method={RequestMethod.POST})
    public ModelAndView addPost(@PathVariable(value="channelId") String channelId, @RequestParameter(required=false, value="name") String name, @RequestParameter(value="file") Part file) {
        try {
            if (name == null || name.isEmpty()) {
                name = file.getSubmittedFileName();
            }
            String finalName = name;
            this.channelService.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.getContext().createArtifact(file.getInputStream(), finalName, null));
            return this.redirectDefaultView(channelId, true);
        }
        catch (Exception e) {
            return CommonController.createError((String)"Upload", (String)"Upload failed", (Throwable)e);
        }
    }

    @RequestMapping(value={"/channel/{channelId}/drop"}, method={RequestMethod.POST})
    public void drop(@PathVariable(value="channelId") String channelId, @RequestParameter(required=false, value="name") String name, @RequestParameter(value="file") Part file, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        try {
            if (name == null || name.isEmpty()) {
                name = file.getSubmittedFileName();
            }
            String finalName = name;
            this.channelService.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.getContext().createArtifact(file.getInputStream(), finalName, null));
        }
        catch (Throwable e) {
            logger.warn("Failed to drop file", e);
            Throwable cause = ExceptionHelper.getRootCause((Throwable)e);
            if (cause instanceof VetoArtifactException) {
                response.setStatus(409);
                response.getWriter().format("Artifact rejected! %s", ((VetoArtifactException)cause).getVetoMessage().orElse("No details given"));
            } else {
                response.setStatus(500);
                response.getWriter().format("Internal error! %s", ExceptionHelper.getMessage((Throwable)cause));
            }
            return;
        }
        response.setStatus(200);
        response.getWriter().write("OK");
    }

    @RequestMapping(value={"/channel/{channelId}/clear"}, method={RequestMethod.GET})
    public ModelAndView clear(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, ModifiableChannel.class, channel -> {
            channel.getContext().clear();
            return this.redirectDefaultView(channelId, true);
        });
    }

    protected ModelAndView redirectDefaultView(String channelId, boolean force) {
        return new ModelAndView(String.valueOf(force ? "redirect" : "referer") + ":/channel/" + channelId + "/view");
    }

    @RequestMapping(value={"/channel/{channelId}/deployKeys"})
    public ModelAndView deployKeys(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, DeployKeysChannelAdapter.class, deployChannel -> this.withChannel(channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            ArrayList<DeployGroup> channelDeployGroups = new ArrayList<DeployGroup>(deployChannel.getDeployGroups());
            Collections.sort(channelDeployGroups, DeployGroup.NAME_COMPARATOR);
            model.put("channel", channel.getInformation());
            model.put("channelDeployGroups", channelDeployGroups);
            model.put("deployGroups", this.getGroupsForChannel(channelDeployGroups));
            model.put("sitePrefix", this.sitePrefix.getSitePrefix());
            return new ModelAndView("channel/deployKeys", model);
        }));
    }

    protected List<DeployGroup> getGroupsForChannel(Collection<DeployGroup> channelDeployGroups) {
        ArrayList<DeployGroup> groups = new ArrayList<DeployGroup>(this.deployAuthService.listGroups(0, -1));
        groups.removeAll(channelDeployGroups);
        Collections.sort(groups, DeployGroup.NAME_COMPARATOR);
        return groups;
    }

    protected <T> ModelAndView withChannel(String channelId, Class<T> clazz, ChannelService.ChannelOperation<ModelAndView, T> operation) {
        return Channels.withChannel((ChannelService)this.channelService, (String)channelId, clazz, operation);
    }

    @RequestMapping(value={"/channel/{channelId}/help/p2"})
    @Secured(value=false)
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView helpP2(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            model.put("sitePrefix", this.sitePrefix.getSitePrefix());
            model.put("p2Active", channel.hasAspect("p2.repo"));
            return new ModelAndView("channel/help/p2", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/help/api"})
    @Secured(value=false)
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView helpApi(@PathVariable(value="channelId") String channelId, HttpServletRequest request) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            String exampleKey;
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            model.put("sitePrefix", this.sitePrefix.getSitePrefix());
            if (request.isUserInRole("MANAGER")) {
                Collection keys = this.channelService.getChannelDeployKeys(ChannelService.By.id((String)channel.getId().getId())).orElse(Collections.emptyList());
                exampleKey = keys.stream().map(DeployKey::getKey).findFirst().orElse(DEFAULT_EXAMPLE_KEY);
            } else {
                exampleKey = DEFAULT_EXAMPLE_KEY;
            }
            model.put("hasExampleKey", !DEFAULT_EXAMPLE_KEY.equals(exampleKey));
            model.put("exampleKey", exampleKey);
            model.put("exampleSitePrefix", this.makeCredentialsPrefix(this.sitePrefix.getSitePrefix(), "deploy", exampleKey));
            return new ModelAndView("channel/help/api", model);
        });
    }

    private String makeCredentialsPrefix(String sitePrefix, String name, String password) {
        try {
            URIBuilder builder = new URIBuilder(sitePrefix);
            builder.setUserInfo(name, password);
            return builder.build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return sitePrefix;
        }
    }

    @RequestMapping(value={"/channel/{channelId}/addDeployGroup"}, method={RequestMethod.POST})
    public ModelAndView addDeployGroup(@PathVariable(value="channelId") String channelId, @RequestParameter(value="groupId") String groupId) {
        return this.modifyDeployGroup(channelId, groupId, DeployKeysChannelAdapter::assignDeployGroup);
    }

    @RequestMapping(value={"/channel/{channelId}/removeDeployGroup"}, method={RequestMethod.POST})
    public ModelAndView removeDeployGroup(@PathVariable(value="channelId") String channelId, @RequestParameter(value="groupId") String groupId) {
        return this.modifyDeployGroup(channelId, groupId, DeployKeysChannelAdapter::unassignDeployGroup);
    }

    protected ModelAndView modifyDeployGroup(String channelId, String groupId, BiConsumer<DeployKeysChannelAdapter, String> cons) {
        return this.withChannel(channelId, DeployKeysChannelAdapter.class, channel -> {
            cons.accept((DeployKeysChannelAdapter)channel, groupId);
            return new ModelAndView("redirect:/channel/" + channelId + "/deployKeys");
        });
    }

    @Secured(value=false)
    @RequestMapping(value={"/channel/{channelId}/aspects"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView aspects(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            ModelAndView model = new ModelAndView("channel/aspects");
            ChannelAspectProcessor aspects = Activator.getAspects();
            Collection groups = aspects.getGroups();
            model.put("channel", (Object)channel.getInformation());
            Set assigned = channel.getInformation().getAspectStates().keySet();
            List<AspectInformation> allAspects = AspectInformation.resolve(groups, aspects.getAspectInformations().values());
            List<AspectInformation> assignedAspects = AspectInformation.filterIds(allAspects, id -> assigned.contains(id));
            model.put("assignedAspects", assignedAspects);
            model.put("groupedAssignedAspects", AspectInformation.group(assignedAspects));
            model.put("addAspects", AspectInformation.group(AspectInformation.filterIds(allAspects, id -> !assigned.contains(id))));
            HashMap<String, String> nameMap = new HashMap<String, String>();
            for (AspectInformation ai : allAspects) {
                nameMap.put(ai.getFactoryId(), ai.getName());
            }
            model.put("nameMapJson", (Object)new GsonBuilder().create().toJson(nameMap));
            model.put("breadcrumbs", (Object)new Breadcrumbs(new Breadcrumbs.Entry("Home", "/"), Breadcrumbs.create("Channel", ChannelController.class, "view", "channelId", channelId), new Breadcrumbs.Entry("Aspects")));
            return model;
        });
    }

    @RequestMapping(value={"/channel/{channelId}/viewAspectVersions"}, method={RequestMethod.GET})
    public ModelAndView viewAspectVersions(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            SortedMap states = channel.getInformation().getAspectStates();
            List aspects = Activator.getAspects().resolve(states.keySet());
            Collections.sort(aspects, ChannelAspectInformation.NAME_COMPARATOR);
            HashMap<String, Object> model = new HashMap<String, Object>(3);
            model.put("channel", channel.getInformation());
            model.put("states", states);
            model.put("aspects", aspects);
            return new ModelAndView("channel/viewAspectVersions", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/lock"}, method={RequestMethod.GET})
    public ModelAndView lock(@PathVariable(value="channelId") String channelId) {
        try {
            this.channelService.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.lock());
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
        return this.redirectDefaultView(channelId, false);
    }

    @RequestMapping(value={"/channel/{channelId}/unlock"}, method={RequestMethod.GET})
    public ModelAndView unlock(@PathVariable(value="channelId") String channelId) {
        try {
            this.channelService.accessRun(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> channel.unlock());
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
        return this.redirectDefaultView(channelId, false);
    }

    @RequestMapping(value={"/channel/{channelId}/addAspect"}, method={RequestMethod.POST})
    public ModelAndView addAspect(@PathVariable(value="channelId") String channelId, @RequestParameter(value="aspect") String aspectFactoryId) {
        return this.withChannel(channelId, AspectableChannel.class, channel -> {
            channel.addAspects(false, new String[]{aspectFactoryId});
            return new ModelAndView(String.format("redirect:aspects", channelId));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/addAspectWithDependencies"}, method={RequestMethod.POST})
    public ModelAndView addAspectWithDependencies(@PathVariable(value="channelId") String channelId, @RequestParameter(value="aspect") String aspectFactoryId) {
        return this.withChannel(channelId, AspectableChannel.class, channel -> {
            channel.addAspects(true, new String[]{aspectFactoryId});
            return new ModelAndView(String.format("redirect:aspects", channelId));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/removeAspect"}, method={RequestMethod.POST})
    public ModelAndView removeAspect(@PathVariable(value="channelId") String channelId, @RequestParameter(value="aspect") String aspectFactoryId) {
        return this.withChannel(channelId, AspectableChannel.class, channel -> {
            channel.removeAspects(new String[]{aspectFactoryId});
            return new ModelAndView(String.format("redirect:aspects", channelId));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/refreshAspect"}, method={RequestMethod.POST})
    public ModelAndView refreshAspect(@PathVariable(value="channelId") String channelId, @RequestParameter(value="aspect") String aspectFactoryId) {
        return this.withChannel(channelId, AspectableChannel.class, channel -> {
            channel.refreshAspects(new String[]{aspectFactoryId});
            return new ModelAndView(String.format("redirect:aspects", channelId));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/refreshAllAspects"}, method={RequestMethod.GET})
    public ModelAndView refreshAllAspects(@PathVariable(value="channelId") String channelId, HttpServletRequest request) {
        return this.withChannel(channelId, AspectableChannel.class, channel -> {
            channel.refreshAspects(new String[0]);
            return this.redirectDefaultView(channelId, false);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/edit"}, method={RequestMethod.GET})
    public ModelAndView edit(@PathVariable(value="channelId") String channelId) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Optional info = this.channelService.getState(ChannelService.By.id((String)channelId));
        if (!info.isPresent()) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
        EditChannel edit = new EditChannel();
        ChannelInformation channel = (ChannelInformation)info.get();
        edit.setId(channel.getId());
        edit.setNames(ChannelController.joinChannelNames(channel.getNames()));
        edit.setDescription(channel.getDescription());
        model.put("command", edit);
        model.put("breadcrumbs", new Breadcrumbs(new Breadcrumbs.Entry("Home", "/"), Breadcrumbs.create("Channel", ChannelController.class, "view", "channelId", channelId), new Breadcrumbs.Entry("Edit")));
        return new ModelAndView("channel/edit", model);
    }

    @RequestMapping(value={"/channel/{channelId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") EditChannel data, BindingResult result) {
        if (!result.hasErrors()) {
            this.channelService.accessRun(ChannelService.By.id((String)channelId), DescriptorAdapter.class, channel -> {
                channel.setNames(ChannelController.splitChannelNames(data.getNames()));
                channel.setDescription(data.getDescription());
            });
            return this.redirectDefaultView(channelId, true);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("command", data);
        model.put("breadcrumbs", new Breadcrumbs(new Breadcrumbs.Entry("Home", "/"), Breadcrumbs.create("Channel", ChannelController.class, "view", "channelId", channelId), new Breadcrumbs.Entry("Edit")));
        return new ModelAndView("channel/edit", model);
    }

    @RequestMapping(value={"/channel/{channelId}/viewCache"}, method={RequestMethod.GET})
    @HttpConstraint(rolesAllowed={"MANAGER", "ADMIN"})
    public ModelAndView viewCache(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            model.put("cacheEntries", channel.getCacheEntries().values());
            return new ModelAndView("channel/viewCache", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/viewCacheEntry"}, method={RequestMethod.GET})
    @HttpConstraint(rolesAllowed={"MANAGER", "ADMIN"})
    public ModelAndView viewCacheEntry(@PathVariable(value="channelId") String channelId, @RequestParameter(value="namespace") String namespace, @RequestParameter(value="key") String key, HttpServletResponse response) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            if (!channel.streamCacheEntry(new MetaKey(namespace, key), entry -> {
                logger.trace("Length: {}, Mime: {}", (Object)entry.getSize(), (Object)entry.getMimeType());
                response.setContentLengthLong(entry.getSize());
                response.setContentType(entry.getMimeType());
                response.setHeader("Content-Disposition", String.format("inline; filename=%s", URLEncoder.encode(entry.getName(), "UTF-8")));
                ByteStreams.copy((InputStream)entry.getStream(), (OutputStream)response.getOutputStream());
            })) {
                return CommonController.createNotFound((String)"channel cache entry", (String)String.format("%s:%s", namespace, key));
            }
            return null;
        });
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (object instanceof ChannelId) {
            ChannelId channel = (ChannelId)object;
            HashMap<String, String> model = new HashMap<String, String>(1);
            model.put("channelId", channel.getId());
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (request.isUserInRole("MANAGER")) {
                if (object instanceof ChannelInformation) {
                    ChannelInformation channelInformation = (ChannelInformation)object;
                    if (!channelInformation.getState().isLocked()) {
                        result.add(new MenuEntry("Add Artifact", 100, LinkTarget.createFromController(ChannelController.class, (String)"add").expand(model), Modifier.PRIMARY, null));
                        result.add(new MenuEntry("Delete Channel", 400, LinkTarget.createFromController(ChannelController.class, (String)"delete").expand(model), Modifier.DANGER, "trash").makeModalMessage("Delete channel", "Are you sure you want to delete the whole channel?"));
                        result.add(new MenuEntry("Clear Channel", 500, LinkTarget.createFromController(ChannelController.class, (String)"clear").expand(model), Modifier.WARNING, null).makeModalMessage("Clear channel", "Are you sure you want to delete all artifacts from this channel?"));
                        result.add(new MenuEntry("Lock Channel", 600, LinkTarget.createFromController(ChannelController.class, (String)"lock").expand(model), Modifier.DEFAULT, null));
                    } else {
                        result.add(new MenuEntry("Unlock Channel", 600, LinkTarget.createFromController(ChannelController.class, (String)"unlock").expand(model), Modifier.DEFAULT, null));
                    }
                }
                result.add(new MenuEntry("Edit", CommonCategories.EDIT.getPriority(), "Edit Channel", 200, LinkTarget.createFromController(ChannelController.class, (String)"edit").expand(model), Modifier.DEFAULT, null));
                result.add(new MenuEntry("Maintenance", 160, "Refresh aspects", 100, LinkTarget.createFromController(ChannelController.class, (String)"refreshAllAspects").expand(model), Modifier.SUCCESS, "refresh"));
            }
            if (request.getRemoteUser() != null) {
                result.add(new MenuEntry("Edit", CommonCategories.EDIT.getPriority(), "Configure Aspects", 300, LinkTarget.createFromController(ChannelController.class, (String)"aspects").expand(model), Modifier.DEFAULT, null));
            }
            return result;
        }
        if (Tags.ACTION_TAG_CHANNELS.equals(object)) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (request.isUserInRole("MANAGER")) {
                result.add(new MenuEntry("Create Channel", 120, LinkTarget.createFromController(ChannelController.class, (String)"createWithRecipe"), Modifier.PRIMARY, null));
            }
            return result;
        }
        if (object instanceof ChannelArtifactInformation) {
            ChannelArtifactInformation ai = (ChannelArtifactInformation)object;
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            HashMap<String, String> model = new HashMap<String, String>(2);
            model.put("channelId", ai.getChannelId().getId());
            model.put("artifactId", ai.getId());
            if (request.isUserInRole("MANAGER") && ai.is("stored")) {
                result.add(new MenuEntry("Attach Artifact", 200, LinkTarget.createFromController(ChannelController.class, (String)"attachArtifact").expand(model), Modifier.PRIMARY, null));
                result.add(new MenuEntry("Delete", 1000, LinkTarget.createFromController(ChannelController.class, (String)"deleteArtifact").expand(model), Modifier.DANGER, "trash"));
            }
            return result;
        }
        return null;
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            ChannelInformation channel = (ChannelInformation)object;
            HashMap<String, String> model = new HashMap<String, String>(1);
            model.put("channelId", channel.getId());
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            result.add(new MenuEntry("Content", 100, LinkTarget.createFromController(ChannelController.class, (String)"view").expand(model), Modifier.DEFAULT, null));
            result.add(new MenuEntry("List", 120, LinkTarget.createFromController(ChannelController.class, (String)"viewPlain").expand(model), Modifier.DEFAULT, null));
            result.add(new MenuEntry("Details", 200, LinkTarget.createFromController(ChannelController.class, (String)"details").expand(model), Modifier.DEFAULT, null));
            result.add(new MenuEntry(null, -1, "Validation", 210, LinkTarget.createFromController(ChannelController.class, (String)"viewValidation").expand(model), Modifier.DEFAULT, null).setBadge(channel.getState().getValidationErrorCount()));
            if (request.isUserInRole("MANAGER")) {
                result.add(new MenuEntry("Deploy Keys", 1000, LinkTarget.createFromController(ChannelController.class, (String)"deployKeys").expand(model), Modifier.DEFAULT, null));
            }
            if (request.isUserInRole("MANAGER") || request.isUserInRole("ADMIN")) {
                result.add(new MenuEntry("Internal", 400, "View Cache", 100, LinkTarget.createFromController(ChannelController.class, (String)"viewCache").expand(model), Modifier.DEFAULT, null));
                result.add(new MenuEntry("Internal", 400, "Aspect Versions", 100, LinkTarget.createFromController(ChannelController.class, (String)"viewAspectVersions").expand(model), Modifier.DEFAULT, null));
            }
            if (channel.hasAspect("p2.repo")) {
                result.add(new MenuEntry("Help", Integer.MAX_VALUE, "P2 Repository", 2000, LinkTarget.createFromController(ChannelController.class, (String)"helpP2").expand(model), Modifier.DEFAULT, "info-sign"));
            }
            result.add(new MenuEntry("Help", Integer.MAX_VALUE, "API Upload", 1100, LinkTarget.createFromController(ChannelController.class, (String)"helpApi").expand(model), Modifier.DEFAULT, "upload"));
            return result;
        }
        return null;
    }

    @ControllerValidator(formDataClass=CreateChannel.class)
    public void validateCreate(CreateChannel data, ValidationContext ctx) {
        this.validateChannelNames(null, ChannelController.splitChannelNames(data.getNames()), ctx);
    }

    @ControllerValidator(formDataClass=EditChannel.class)
    public void validateEdit(EditChannel data, ValidationContext ctx) {
        this.validateChannelNames(data.getId(), ChannelController.splitChannelNames(data.getNames()), ctx);
    }

    private void validateChannelNames(String id, Iterable<String> names, ValidationContext ctx) {
        for (String name : names) {
            ChannelController.validateChannelName(name, ctx);
            this.validateChannelNameUnique(id, name, ctx);
        }
    }

    private static void validateChannelName(String name, ValidationContext ctx) {
        if (name == null || name.isEmpty()) {
            return;
        }
        Matcher m = ChannelService.NAME_PATTERN.matcher(name);
        if (!m.matches()) {
            ctx.error("names", String.format("The channel name '%s' must match the pattern '%s'", name, ChannelService.NAME_PATTERN.pattern()));
        }
    }

    private void validateChannelNameUnique(String id, String name, ValidationContext ctx) {
        if (name == null || name.isEmpty()) {
            return;
        }
        ChannelInformation other = this.channelService.getState(ChannelService.By.name((String)name)).orElse(null);
        if (other == null) {
            return;
        }
        if (id != null && other.getId().equals(id)) {
            return;
        }
        ctx.error("names", String.format("The channel name '%s' is already in use by channel '%s'", name, other.getId()));
    }

    @RequestMapping(value={"/channel/{channelId}/artifact/{artifactId}/attach"}, method={RequestMethod.GET})
    public ModelAndView attachArtifact(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return this.withChannel(channelId, ReadableChannel.class, channel -> {
            Optional artifact = channel.getArtifact(artifactId);
            if (!artifact.isPresent()) {
                return CommonController.createNotFound((String)"artifact", (String)artifactId);
            }
            return new ModelAndView("/artifact/attach", "artifact", artifact.get());
        });
    }

    @RequestMapping(value={"/channel/{channelId}/artifact/{artifactId}/attach"}, method={RequestMethod.POST})
    public ModelAndView attachArtifactPost(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId, @RequestParameter(required=false, value="name") String name, @RequestParameter(value="file") Part file) {
        return this.withChannel(channelId, ModifiableChannel.class, channel -> {
            String targetName = name;
            Optional parentArtifact = channel.getArtifact(artifactId);
            if (!parentArtifact.isPresent()) {
                return CommonController.createNotFound((String)"artifact", (String)artifactId);
            }
            try {
                if (targetName == null || targetName.isEmpty()) {
                    targetName = file.getSubmittedFileName();
                }
                channel.getContext().createArtifact(artifactId, file.getInputStream(), targetName, null);
            }
            catch (IOException iOException) {
                return new ModelAndView("/error/upload");
            }
            return new ModelAndView("redirect:/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/view");
        });
    }

    public void extend(UrlSetContext context) {
        context.addLocation("/channel", Optional.ofNullable(this.calcLastMod()), Optional.of(ChangeFrequency.DAILY), Optional.empty());
    }

    private Instant calcLastMod() {
        Instant globalLastMod = null;
        for (ChannelInformation ci : this.channelService.list()) {
            Optional<Instant> lastMod = Optional.ofNullable(ci.getState().getModificationTimestamp());
            if (globalLastMod != null && !lastMod.get().isAfter(globalLastMod)) continue;
            globalLastMod = lastMod.get();
        }
        return globalLastMod;
    }

    public static class ChannelListEntry {
        private final ChannelListEntryKey key;
        private final ChannelInformation channel;

        public ChannelListEntry(ChannelListEntryKey key, ChannelInformation channel) {
            this.key = key;
            this.channel = channel;
        }

        public ChannelListEntryKey getKey() {
            return this.key;
        }

        public ChannelInformation getChannel() {
            return this.channel;
        }
    }

    public static class ChannelListEntryKey {
        private final Modifier modifier;
        private final String id;
        private final String by;

        public ChannelListEntryKey(Modifier modifier, String id, String by) {
            this.modifier = modifier;
            this.id = id;
            this.by = by;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public String getId() {
            return this.id;
        }

        public String getBy() {
            return this.by;
        }
    }
}

