/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.mail.web;

import java.io.IOException;
import java.security.Principal;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.mail.java.DefaultMailService;
import org.eclipse.packagedrone.mail.web.MailSettings;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.sec.DatabaseDetails;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.UserInformationPrincipal;
import org.eclipse.packagedrone.sec.web.controller.HttpConstraints;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@RequestMapping(value={"/default.mail/config"})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class ConfigController
implements InterfaceExtender {
    private static final Logger logger = LoggerFactory.getLogger(ConfigController.class);
    private ConfigurationAdmin admin;
    private volatile DefaultMailService mailService;
    private SitePrefixService sitePrefix;
    private static final LinkTarget.ControllerMethod METHOD_INDEX = LinkTarget.getControllerMethod(ConfigController.class, (String)"index");

    public void setMailService(DefaultMailService mailService) {
        this.mailService = mailService;
    }

    public void unsetMailService(DefaultMailService mailService) {
        this.mailService = null;
    }

    public void setAdmin(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    public void setSitePrefixService(SitePrefixService sitePrefix) {
        this.sitePrefix = sitePrefix;
    }

    @RequestMapping
    public ModelAndView index() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("command", this.getCurrent());
        this.fillModel(model);
        return new ModelAndView("index", model);
    }

    private void fillModel(Map<String, Object> model) {
        model.put("servicePresent", this.mailService != null);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView update(@Valid @FormData(value="command") MailSettings settings, BindingResult bindingResult) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (!bindingResult.hasErrors()) {
            this.setCurrent(settings);
        }
        int i = 10;
        while (this.mailService == null && i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            --i;
        }
        this.fillModel(model);
        return new ModelAndView("index", model);
    }

    protected void setCurrent(MailSettings settings) {
        try {
            Configuration cfg = this.admin.getConfiguration("org.eclipse.packagedrone.mail.default");
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            this.put(properties, "username", settings.getUsername());
            this.put(properties, "password", settings.getPassword());
            this.put(properties, "from", settings.getFrom());
            this.put(properties, "prefix", settings.getPrefix());
            this.put(properties, "properties.mail.transport.protocol", "smtp");
            this.put(properties, "properties.mail.smtp.host", settings.getHost());
            this.put(properties, "properties.mail.smtp.port", settings.getPort());
            if (settings.isEnableStartTls()) {
                this.put(properties, "properties.mail.smtp.starttls.enable", "true");
            }
            cfg.update(properties);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update mail server configuration", e);
        }
    }

    private void put(Dictionary<String, Object> properties, String key, Object value) {
        if (value instanceof String && ((String)value).isEmpty()) {
            return;
        }
        if (value != null) {
            properties.put(key, value);
        }
    }

    protected MailSettings getCurrent() {
        try {
            Configuration cfg = this.admin.getConfiguration("org.eclipse.packagedrone.mail.default");
            if (cfg == null || cfg.getProperties() == null) {
                return this.createDefault();
            }
            MailSettings result = new MailSettings();
            result.setUsername(this.getString(cfg, "username"));
            result.setPassword(this.getString(cfg, "password"));
            result.setFrom(this.getString(cfg, "from"));
            result.setPrefix(this.getString(cfg, "prefix"));
            result.setHost(this.getString(cfg, "properties.mail.smtp.host"));
            result.setPort(this.getInteger(cfg, "properties.mail.smtp.port"));
            return result;
        }
        catch (IOException iOException) {
            return this.createDefault();
        }
    }

    private Integer getInteger(Configuration cfg, String key) {
        Object val = cfg.getProperties().get(key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private String getString(Configuration cfg, String key) {
        Object val = cfg.getProperties().get(key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    protected MailSettings createDefault() {
        MailSettings result = new MailSettings();
        return result;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_INDEX, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 100, "Mail", 700, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_INDEX), null, null));
        }
        return result;
    }

    @RequestMapping(value={"/sendTest"}, method={RequestMethod.POST})
    public ModelAndView sendTest(@RequestParameter(value="testEmailReceiver") String email, Principal principal) {
        HashMap model = new HashMap();
        try {
            UserInformation userInfo;
            DatabaseDetails dbDetails;
            String user = principal.getName();
            if (principal instanceof UserInformationPrincipal && (dbDetails = (DatabaseDetails)(userInfo = ((UserInformationPrincipal)principal).getUserInformation()).getDetails(DatabaseDetails.class)) != null && dbDetails.getEmail() != null) {
                user = dbDetails.getEmail();
            }
            String message = "This is an automated test message requested by: " + user;
            StringBuilder html = new StringBuilder();
            html.append("<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><title>Package Drone | Account verification</title></head><body>");
            html.append("<p>").append(message).append("</p>");
            html.append("<p><a href='" + this.sitePrefix.getSitePrefix() + "' target='_blank'>Link</a> to you Package Drone installation.</p>");
            html.append("</body></html>");
            this.mailService.sendMessage(email, "Test Mail", message, html.toString());
        }
        catch (Throwable e) {
            logger.warn("Failed to send test e-mail", e);
            return CommonController.createError((String)"Test Mail", (String)"Result", null, (Throwable)e, (Boolean)true);
        }
        return new ModelAndView("testSent", model);
    }
}

