/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.generator.ArtifactGenerator;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.repo.generator.p2.GeneratorController;
import org.eclipse.packagedrone.repo.generator.p2.Helper;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.web.LinkTarget;
import org.w3c.dom.Element;

public class CategoryGenerator
implements ArtifactGenerator {
    public static final String ID = "p2.category";

    public LinkTarget getAddTarget() {
        return LinkTarget.createFromController(GeneratorController.class, (String)"createCategory");
    }

    public LinkTarget getEditTarget(ChannelArtifactInformation artifact) {
        HashMap<String, String> model = new HashMap<String, String>(2);
        model.put("channelId", artifact.getChannelId().getId());
        model.put("artifactId", artifact.getId());
        String url = LinkTarget.createFromController(GeneratorController.class, (String)"editCategory").render(model);
        return new LinkTarget(url);
    }

    public void generate(GenerationContext context) throws Exception {
        String id = MetaKeys.getString((Map)context.getArtifactInformation().getMetaData(), (String)ID, (String)"id");
        context.createVirtualArtifact(String.format("%s-p2metadata.xml", id), out -> this.createMetaDataXml((OutputStream)out, context.getArtifactInformation().getMetaData(), context), null);
    }

    private void createMetaDataXml(OutputStream out, Map<MetaKey, String> map, GenerationContext context) throws IOException {
        String id = MetaKeys.getString(map, (String)ID, (String)"id");
        String name = MetaKeys.getString(map, (String)ID, (String)"name");
        String description = MetaKeys.getString(map, (String)ID, (String)"description");
        String version = MetaKeys.getString(map, (String)ID, (String)"version", (String)Helper.makeDefaultVersion());
        Helper.createFragmentFile(out, units -> Helper.createCategoryUnit(units, id, name, description, version, unit -> {
            HashSet<String> ctx = new HashSet<String>();
            Element reqs = XmlHelper.addElement((Element)unit, (String)"requires");
            for (ArtifactInformation a : context.getChannelArtifacts()) {
                if (!Helper.isFeature(a.getMetaData())) continue;
                Helper.addFeatureRequirement(ctx, reqs, a);
            }
            XmlHelper.fixSize((Element)reqs);
        }));
    }

    public boolean shouldRegenerate(Object event) {
        return Helper.shouldRegenerateCategory(event);
    }
}

