/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.search;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.search.And;
import org.eclipse.packagedrone.repo.channel.search.Equal;
import org.eclipse.packagedrone.repo.channel.search.IsNull;
import org.eclipse.packagedrone.repo.channel.search.Like;
import org.eclipse.packagedrone.repo.channel.search.Literal;
import org.eclipse.packagedrone.repo.channel.search.MetaKeyValue;
import org.eclipse.packagedrone.repo.channel.search.Not;
import org.eclipse.packagedrone.repo.channel.search.Or;
import org.eclipse.packagedrone.repo.channel.search.Predicate;
import org.eclipse.packagedrone.repo.channel.search.Value;

public final class Predicates {
    public static final String LIKE_WILDCARD_MANY = "%";
    public static final String LIKE_WILDCARD_SINGLE = "_";

    private Predicates() {
    }

    public static Predicate and(Predicate ... predicates) {
        return new And(predicates);
    }

    public static Predicate and(Collection<Predicate> predicates) {
        return new And(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return new Or(predicates);
    }

    public static Predicate not(Predicate predicate) {
        return new Not(predicate);
    }

    public static Predicate isNull(Value value) {
        return new IsNull(value);
    }

    public static Predicate isNotNull(Value value) {
        return Predicates.not(Predicates.isNull(value));
    }

    public static Literal literal(String value) {
        return new Literal(value);
    }

    public static Value attribute(MetaKey key) {
        return new MetaKeyValue(key);
    }

    public static Predicate equal(Value value1, Value value2) {
        return new Equal(value1, value2);
    }

    public static Predicate equal(MetaKey key, String literal) {
        return new Equal(Predicates.attribute(key), Predicates.literal(literal));
    }

    public static Predicate equal(MetaKey key, Optional<String> literal) {
        if (literal.isPresent()) {
            return Predicates.equal(Predicates.attribute(key), Predicates.literal(literal.get()));
        }
        return Predicates.isNull(Predicates.attribute(key));
    }

    public static Predicate like(Value value, Literal pattern) {
        return new Like(value, pattern, true);
    }

    public static Predicate like(MetaKey key, String literal) {
        return new Like(Predicates.attribute(key), Predicates.literal(literal), true);
    }

    public static Predicate like(Value value, Literal pattern, boolean caseSensitive) {
        return new Like(value, pattern, caseSensitive);
    }

    public static Predicate like(MetaKey key, String literal, boolean caseSensitive) {
        return new Like(Predicates.attribute(key), Predicates.literal(literal), caseSensitive);
    }
}

