/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.Objects;
import org.eclipse.packagedrone.utils.rpm.RpmVersion;

public class RpmLead {
    private final byte major;
    private final byte minor;
    private final String name;
    private final int signatureVersion;
    private final short type;
    private final short architecture;
    private final short operatingSystem;

    public RpmLead(byte major, byte minor, String name, int signatureVersion, short type, short architecture, short operatingSystem) {
        Objects.requireNonNull(name);
        this.major = major;
        this.minor = minor;
        this.name = name;
        this.signatureVersion = signatureVersion;
        this.type = type;
        this.architecture = architecture;
        this.operatingSystem = operatingSystem;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public String getName() {
        return this.name;
    }

    public int getSignatureVersion() {
        return this.signatureVersion;
    }

    public short getType() {
        return this.type;
    }

    public short getArchitecture() {
        return this.architecture;
    }

    public short getOperatingSystem() {
        return this.operatingSystem;
    }

    public static String toLeadName(String packageName, RpmVersion version) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(version);
        StringBuilder builder = new StringBuilder();
        builder.append(packageName);
        builder.append('-').append(version.getVersion());
        if (version.getRelease().isPresent()) {
            builder.append('-').append(version.getRelease().get());
        }
        return builder.toString();
    }
}

