/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.internal;

import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;

public class MavenPomVirtualizer
implements Virtualizer {
    private static final String DEFAULT_POM_NAME = "pom.xml";

    public void virtualize(Virtualizer.Context context) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(context.getFile().toFile()));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if (!name.startsWith("META-INF/maven/") || !name.endsWith("/pom.xml")) continue;
                    this.extractPom(entry, zis, context);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void extractPom(ZipEntry entry, ZipInputStream zis, Virtualizer.Context context) {
        String name = this.makeName(context.getArtifactInformation().getName());
        context.createVirtualArtifact(name, out -> {
            long l = ByteStreams.copy((InputStream)zis, (OutputStream)out);
        }, null);
    }

    private String makeName(String name) {
        if (name == null) {
            return DEFAULT_POM_NAME;
        }
        int idx = name.lastIndexOf(46);
        if (idx < 0 || idx >= name.length()) {
            return DEFAULT_POM_NAME;
        }
        return String.valueOf(name.substring(0, idx)) + ".pom";
    }
}

