/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.Version;
import org.eclipse.packagedrone.repo.aspect.group.GroupInformation;

public class AspectInformation {
    private static final Comparator<AspectInformation> NAME_COMPARATOR = new Comparator<AspectInformation>(){

        @Override
        public int compare(AspectInformation o1, AspectInformation o2) {
            int rc = o1.getName().compareTo(o2.getName());
            if (rc != 0) {
                return rc;
            }
            return o1.getFactoryId().compareTo(o2.getFactoryId());
        }
    };
    private Group group;
    private final ChannelAspectInformation information;
    private List<AspectInformation> requires = Collections.emptyList();

    public AspectInformation(ChannelAspectInformation information) {
        this.information = information;
    }

    public String getName() {
        return this.information.getLabel();
    }

    public String getFactoryId() {
        return this.information.getFactoryId();
    }

    public ChannelAspectInformation getInformation() {
        return this.information;
    }

    public boolean isResolved() {
        return this.information.isResolved();
    }

    public Version getVersion() {
        return this.information.getVersion();
    }

    public List<AspectInformation> getRequires() {
        return this.requires;
    }

    public Group getGroup() {
        return this.group;
    }

    public static List<AspectInformation> resolve(Collection<GroupInformation> groups, Collection<ChannelAspectInformation> aspects) {
        if (aspects == null) {
            return null;
        }
        HashMap<String, AspectInformation> map = new HashMap<String, AspectInformation>(aspects.size());
        for (ChannelAspectInformation aspect : aspects) {
            map.put(aspect.getFactoryId(), new AspectInformation(aspect));
        }
        HashMap<String, Group> groupMap = new HashMap<String, Group>(groups.size());
        for (GroupInformation gi : groups) {
            groupMap.put(gi.getId(), new Group(gi.getId(), gi.getName()));
        }
        ArrayList<AspectInformation> result = new ArrayList<AspectInformation>(aspects.size());
        for (AspectInformation info : map.values()) {
            info.resolveDeps(map);
            info.group = (Group)groupMap.get(info.information.getGroupId());
            if (info.group == null) {
                info.group = Group.OTHER;
            }
            result.add(info);
        }
        Collections.sort(result, NAME_COMPARATOR);
        return result;
    }

    private void resolveDeps(Map<String, AspectInformation> map) {
        if (this.information.getRequires() == null) {
            this.requires = Collections.emptyList();
            return;
        }
        this.requires = new ArrayList<AspectInformation>(this.information.getRequires().size());
        for (String req : this.information.getRequires()) {
            AspectInformation reqInfo = map.get(req);
            if (reqInfo == null) {
                reqInfo = new AspectInformation(ChannelAspectInformation.unresolved((String)req));
            }
            this.requires.add(reqInfo);
        }
        Collections.sort(this.requires, NAME_COMPARATOR);
    }

    public static List<AspectInformation> filterIds(List<AspectInformation> list, Predicate<String> predicate) {
        if (list == null) {
            return null;
        }
        return list.stream().filter(i -> predicate.test(i.getFactoryId())).collect(Collectors.toList());
    }

    public String[] getMissingIds(List<AspectInformation> assignedAspects) {
        HashSet<AspectInformation> required = new HashSet<AspectInformation>();
        AspectInformation.addRequired(required, this, assignedAspects);
        return (String[])required.stream().map(AspectInformation::getFactoryId).toArray(String[]::new);
    }

    private static void addRequired(Set<AspectInformation> result, AspectInformation aspect, List<AspectInformation> assignedAspects) {
        for (AspectInformation req : aspect.getRequires()) {
            if (assignedAspects.contains(req) || !result.add(req)) continue;
            AspectInformation.addRequired(result, req, assignedAspects);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getFactoryId() == null ? 0 : this.getFactoryId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AspectInformation)) {
            return false;
        }
        AspectInformation other = (AspectInformation)obj;
        return !(this.getFactoryId() == null ? other.getFactoryId() != null : !this.getFactoryId().equals(other.getFactoryId()));
    }

    public static Map<Group, List<AspectInformation>> group(List<AspectInformation> aspects) {
        HashMap<Group, List<AspectInformation>> result = new HashMap<Group, List<AspectInformation>>();
        for (AspectInformation ai : aspects) {
            LinkedList<AspectInformation> list = (LinkedList<AspectInformation>)result.get(ai.getGroup());
            if (list == null) {
                list = new LinkedList<AspectInformation>();
                result.put(ai.getGroup(), list);
            }
            list.add(ai);
        }
        return result;
    }

    public String toString() {
        return String.format("[%s: %s]", this.information, this.group);
    }

    public static class Group
    implements Comparable<Group> {
        public static final Group OTHER = new Group("other", "Other");
        private final String id;
        private final String name;

        public Group(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Group o) {
            int rc = this.name.compareTo(o.name);
            if (rc != 0) {
                return rc;
            }
            return this.id.compareTo(o.id);
        }

        public String toString() {
            return this.id;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Group)) {
                return false;
            }
            Group other = (Group)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

