/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.core.apm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.repo.manage.core.apm.CoreServiceModel;
import org.eclipse.packagedrone.repo.manage.core.apm.CoreServiceViewModel;
import org.eclipse.packagedrone.repo.manage.core.apm.CoreStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;

public class CoreServiceImpl
implements CoreService {
    private static final MetaKey MODEL_KEY = new MetaKey("core", "default");
    private StorageManager manager;
    private StorageRegistration handle;

    public void setStorageManager(StorageManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.handle = this.manager.registerModel(100000L, MODEL_KEY, (StorageModelProvider)new CoreStorageModelProvider());
    }

    public void stop() {
        this.handle.unregister();
    }

    public String getCoreProperty(MetaKey key, String defaultValue) {
        return (String)this.manager.accessCall(MODEL_KEY, CoreServiceViewModel.class, model -> model.getProperties().get(key));
    }

    public Map<MetaKey, String> getCoreProperties(Collection<MetaKey> keys) {
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>(keys.size());
        Map<MetaKey, String> all = this.list();
        for (MetaKey key : keys) {
            result.put(key, all.get(key));
        }
        return result;
    }

    public void setCoreProperty(MetaKey key, String value) {
        this.manager.modifyRun(MODEL_KEY, CoreServiceModel.class, model -> {
            if (value == null) {
                model.getProperties().remove(value);
            } else {
                model.getProperties().put(key, value);
            }
        });
    }

    public Map<MetaKey, String> list() {
        return (Map)this.manager.accessCall(MODEL_KEY, CoreServiceViewModel.class, model -> model.getProperties());
    }

    public void setCoreProperties(Map<MetaKey, String> properties) {
        this.manager.modifyRun(MODEL_KEY, CoreServiceModel.class, model -> {
            for (Map.Entry entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                if (value != null) {
                    model.getProperties().put((MetaKey)entry.getKey(), value);
                    continue;
                }
                model.getProperties().remove(entry.getKey());
            }
        });
    }
}

