/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether.web;

import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.packagedrone.repo.XmlHelper;
import org.eclipse.packagedrone.repo.importer.aether.MavenCoordinates;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Helper {
    private Helper() {
    }

    public static Collection<MavenCoordinates> parse(String string, XmlToolsFactory xml) {
        try {
            return Helper.parseCoordinates(string);
        }
        catch (Exception exception) {
            try {
                return Helper.parseXml(string, xml);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static Collection<MavenCoordinates> parseCoordinates(String string) {
        String[] toks = string.split("[\\n\\r]+");
        LinkedList<MavenCoordinates> result = new LinkedList<MavenCoordinates>();
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            if (!(tok = tok.trim()).isEmpty()) {
                result.add(MavenCoordinates.fromString(tok));
            }
            ++n2;
        }
        return result;
    }

    private static Collection<MavenCoordinates> parseXml(String string, XmlToolsFactory xml) throws Exception {
        Document doc;
        DocumentBuilder db = xml.newDocumentBuilder();
        db.setErrorHandler(null);
        try {
            doc = db.parse(new InputSource(new StringReader(string)));
        }
        catch (SAXException sAXException) {
            doc = db.parse(new InputSource(new StringReader("<dependencies>" + string + "</dependencies>")));
        }
        Element root = doc.getDocumentElement();
        if ("dependencies".equals(root.getTagName())) {
            return Helper.parseDependenciesXml(root);
        }
        if ("dependency".equals(root.getTagName())) {
            return Collections.singletonList(Helper.parseDependencyXml(root));
        }
        throw new IllegalStateException();
    }

    private static Collection<MavenCoordinates> parseDependenciesXml(Element root) {
        LinkedList<MavenCoordinates> result = new LinkedList<MavenCoordinates>();
        for (Node node : XmlHelper.iter((NodeList)root.getChildNodes())) {
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if (!"dependency".equals(ele.getTagName())) {
                throw new IllegalStateException();
            }
            result.add(Helper.parseDependencyXml(ele));
        }
        return result;
    }

    private static MavenCoordinates parseDependencyXml(Element ele) {
        String groupId = XmlHelper.getText((Element)ele, (String)"groupId");
        String artifactId = XmlHelper.getText((Element)ele, (String)"artifactId");
        String version = XmlHelper.getText((Element)ele, (String)"version");
        String classifier = XmlHelper.getText((Element)ele, (String)"classifier ");
        String extension = XmlHelper.getText((Element)ele, (String)"extension");
        if (groupId == null || artifactId == null || version == null) {
            throw new IllegalArgumentException();
        }
        MavenCoordinates coords = new MavenCoordinates(groupId, artifactId, version);
        coords.setExtension(extension);
        coords.setClassifier(classifier);
        return coords;
    }
}

