/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.r5.internal;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.r5.internal.handler.NotFoundHandler;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.repo.servlet.Handler;
import org.eclipse.packagedrone.repo.web.utils.ChannelCacheHandler;
import org.eclipse.packagedrone.utils.io.FileNames;

public abstract class CommonRepoServlet
extends AbstractChannelServiceServlet {
    private static final long serialVersionUID = 1L;
    private final MetaKey keyToIndex;
    private final ChannelCacheHandler indexHandler;

    public CommonRepoServlet(MetaKey keyToIndex) {
        this.keyToIndex = keyToIndex;
        this.indexHandler = new ChannelCacheHandler(this.keyToIndex);
    }

    protected NotFoundHandler resourceNotFound(HttpServletRequest req) {
        return new NotFoundHandler(String.format("Resource '%s' not found.%n", req.getPathInfo()));
    }

    protected boolean process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String[] toks;
        String channelId;
        String path = req.getPathInfo();
        if (path == null || path.isEmpty() || "/".equals(path)) {
            this.getHelpHandler().process(req, resp);
            return true;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String string = channelId = (toks = path.split("\\/", 4)).length > 0 ? toks[0] : null;
        if (toks.length == 1) {
            try {
                this.getService(req).accessRun(ChannelService.By.nameOrId((String)channelId), ReadableChannel.class, channel -> this.indexHandler.process(channel, req, resp));
            }
            catch (ChannelNotFoundException channelNotFoundException) {
                new NotFoundHandler(String.format("Channel '%s' not found.", channelId)).process(req, resp);
            }
            return true;
        }
        if ((toks.length == 3 || toks.length == 4) && "artifact".equals(toks[1])) {
            String artifactId = toks[2];
            try {
                this.getService(req).accessRun(ChannelService.By.nameOrId((String)toks[0]), ReadableChannel.class, channel -> {
                    Optional artifact = channel.getArtifact(artifactId);
                    if (!artifact.isPresent()) {
                        new NotFoundHandler(String.format("Artifact '%s' not found.", artifactId)).process(req, resp);
                    } else {
                        DownloadHelper.streamArtifact((HttpServletResponse)resp, (ArtifactInformation)((ArtifactInformation)artifact.get()), Optional.of("application/vnd.osgi.bundle"), (boolean)true, (ReadableChannel)channel, art -> FileNames.getBasename((String)(toks.length == 4 ? toks[3] : art.getName())));
                    }
                });
            }
            catch (ChannelNotFoundException channelNotFoundException) {
                new NotFoundHandler(String.format("Channel '%s' not found.", channelId)).process(req, resp);
            }
            return true;
        }
        return false;
    }

    protected abstract Handler getHelpHandler();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean didProcess = this.process(req, resp);
        if (!didProcess) {
            this.resourceNotFound(req).process(req, resp);
        }
    }
}

