/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.p2.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.stream.XMLOutputFactory;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiAspectFactory;
import org.eclipse.packagedrone.repo.aspect.common.p2.P2MetaDataInformation;
import org.eclipse.packagedrone.repo.aspect.common.p2.internal.Creator;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.utils.Exceptions;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2Virtualizer
implements Virtualizer {
    static final MetaKey KEY_MD5 = new MetaKey("hasher", "md5");
    private static final Logger logger = LoggerFactory.getLogger(P2Virtualizer.class);
    private final Supplier<XMLOutputFactory> factoryProvider;

    public P2Virtualizer(Supplier<XMLOutputFactory> factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public void virtualize(Virtualizer.Context context) {
        Exceptions.wrapException(() -> this.processVirtualize(context));
    }

    private void processVirtualize(final Virtualizer.Context context) throws Exception {
        ArtifactInformation art = context.getArtifactInformation();
        Map metaData = context.getProvidedChannelMetaData();
        P2MetaDataInformation info = new P2MetaDataInformation();
        MetaKeys.bind((Object)info, (Map)metaData);
        logger.debug("Process virtualize - artifactId: {} / {}", (Object)art.getId(), (Object)art.getName());
        Creator creator = new Creator(new Creator.Context(){

            @Override
            public void create(String name, IOConsumer<OutputStream> producer) throws IOException {
                context.createVirtualArtifact(name, producer, null);
            }
        }, this.factoryProvider);
        BundleInformation bi = OsgiAspectFactory.fetchBundleInformation(art.getMetaData());
        if (bi != null) {
            logger.debug("Process as bundle: {} ({})- {}", new Object[]{art.getName(), art.getId(), bi});
            creator.createBundleP2MetaData(info, art, bi);
            creator.createBundleP2Artifacts(art, bi);
            return;
        }
        FeatureInformation fi = OsgiAspectFactory.fetchFeatureInformation(art.getMetaData());
        if (fi != null) {
            logger.debug("Process as feature: {} ({}) - {}", new Object[]{art.getName(), art.getId(), fi});
            creator.createFeatureP2MetaData(art, fi);
            creator.createFeatureP2Artifacts(art, fi);
            return;
        }
    }
}

