/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmEntry;

public class RpmHeader<T extends RpmBaseTag> {
    private final Map<Integer, Object> tags;
    private final long start;
    private final long length;

    public RpmHeader(RpmEntry[] entries, long start, long length) {
        HashMap<Integer, Object> tags = new HashMap<Integer, Object>(entries.length);
        RpmEntry[] rpmEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RpmEntry entry = rpmEntryArray[n2];
            tags.put(entry.getTag(), entry.getValue());
            ++n2;
        }
        this.tags = Collections.unmodifiableMap(tags);
        this.start = start;
        this.length = length;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public Object getTag(T tag) {
        return this.tags.get(tag.getValue());
    }

    public Object getTagOrDefault(T tag, Object defaultValue) {
        return this.tags.getOrDefault(tag, defaultValue);
    }

    public Map<Integer, Object> getRawTags() {
        return this.tags;
    }
}

