/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.util.IOUtil;

public class EclipseIniTaskImpl
extends SetupTaskImpl
implements EclipseIniTask {
    protected static final String OPTION_EDEFAULT = null;
    protected String option = OPTION_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final boolean VM_EDEFAULT = false;
    protected boolean vm = false;
    private transient File file;
    private transient List<String> contents;

    protected EclipseIniTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.ECLIPSE_INI_TASK;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String newOption) {
        String oldOption = this.option;
        this.option = newOption;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldOption, (Object)this.option));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldValue, (Object)this.value));
        }
    }

    public boolean isVm() {
        return this.vm;
    }

    public void setVm(boolean newVm) {
        boolean oldVm = this.vm;
        this.vm = newVm;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldVm, this.vm));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getOption();
            }
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.isVm();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setOption((String)newValue);
                return;
            }
            case 11: {
                this.setValue((String)newValue);
                return;
            }
            case 12: {
                this.setVm((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setOption(OPTION_EDEFAULT);
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 12: {
                this.setVm(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return OPTION_EDEFAULT == null ? this.option != null : !OPTION_EDEFAULT.equals(this.option);
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.vm;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (option: ");
        result.append(this.option);
        result.append(", value: ");
        result.append(this.value);
        result.append(", vm: ");
        result.append(this.vm);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        return 201;
    }

    public String getLabel(String value) {
        return String.valueOf(this.getOption()) + (value == null ? "" : String.valueOf(this.isVm() ? "" : " ") + value);
    }

    public Object getOverrideToken() {
        return this.createToken(this.getOption());
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (context.getTrigger() == Trigger.BOOTSTRAP) {
            return true;
        }
        if (context.isSelfHosting()) {
            return false;
        }
        this.file = new File(context.getProductLocation(), String.valueOf(context.getLauncherName()) + ".ini");
        boolean result = !this.file.exists() || this.createNewContent(context);
        this.contents = null;
        return result;
    }

    public void perform(SetupTaskContext context) throws Exception {
        if (this.file == null) {
            this.file = new File(context.getProductLocation(), String.valueOf(context.getLauncherName()) + ".ini");
        }
        if (!this.file.exists()) {
            context.log("Skipping because " + this.file + " does not exist");
            return;
        }
        if (this.contents != null || this.createNewContent(context)) {
            context.log("Changing " + this.file + " (" + this.getLabel(this.getValue()) + ")");
            IOUtil.writeLines((File)this.file, null, this.contents);
            context.setRestartNeeded("The " + this.file.getName() + " file has changed.");
        }
    }

    private boolean createNewContent(SetupTaskContext context) {
        List oldContents = IOUtil.readLines((File)this.file, null);
        this.contents = new ArrayList<String>(oldContents);
        int vmargsIndex = this.contents.indexOf("-vmargs");
        String option = this.getOption();
        String value = this.getValue();
        if (value != null && value.trim().isEmpty()) {
            value = null;
        }
        if (this.isVm()) {
            String line = String.valueOf(option) + (value == null ? "" : value);
            if (vmargsIndex != -1) {
                int i = vmargsIndex + 1;
                while (i < this.contents.size()) {
                    String oldLine = this.contents.get(i);
                    if (oldLine.startsWith(option)) {
                        this.contents.set(i, line);
                        line = null;
                        break;
                    }
                    ++i;
                }
            } else {
                this.contents.add("-vmargs");
            }
            if (line != null) {
                this.contents.add(line);
            }
        } else {
            int optionIndex = this.contents.indexOf(option);
            if (optionIndex != -1) {
                if (value != null) {
                    this.contents.set(optionIndex + 1, value);
                }
            } else {
                optionIndex = vmargsIndex != -1 ? vmargsIndex : this.contents.size();
                this.contents.add(optionIndex, option);
                if (value != null) {
                    this.contents.add(optionIndex + 1, value);
                }
            }
        }
        return !this.contents.equals(oldContents);
    }
}

