/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AbstractEnabledHandler;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public abstract class AbstractEvaluationHandler
extends AbstractEnabledHandler {
    private static final String PROP_ENABLED = "enabled";
    private IEvaluationService evaluationService;
    private IPropertyChangeListener enablementListener;
    private IEvaluationReference enablementRef;

    protected IEvaluationService getEvaluationService() {
        if (this.evaluationService == null) {
            this.evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        }
        return this.evaluationService;
    }

    protected void registerEnablement() {
        this.enablementRef = this.getEvaluationService().addEvaluationListener(this.getEnabledWhenExpression(), this.getEnablementListener(), PROP_ENABLED);
    }

    protected abstract Expression getEnabledWhenExpression();

    private IPropertyChangeListener getEnablementListener() {
        if (this.enablementListener == null) {
            this.enablementListener = event -> {
                if (event.getProperty() == PROP_ENABLED) {
                    if (event.getNewValue() instanceof Boolean) {
                        this.setEnabled((Boolean)event.getNewValue());
                    } else {
                        this.setEnabled(false);
                    }
                }
            };
        }
        return this.enablementListener;
    }

    public void dispose() {
        if (this.enablementRef != null) {
            this.evaluationService.removeEvaluationListener(this.enablementRef);
            this.enablementRef = null;
            this.enablementListener = null;
            this.evaluationService = null;
        }
        super.dispose();
    }
}

