/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.oomph.util.AbstractIterator;

public class ComposedIterator<T>
extends AbstractIterator<T> {
    private final Iterator<? extends Iterator<T>> delegates;
    private Iterator<T> currentDelegate;

    @SafeVarargs
    public ComposedIterator(Iterator<T> ... delegates) {
        this(Arrays.asList(delegates));
    }

    public ComposedIterator(Collection<? extends Iterator<T>> delegates) {
        this((Iterator<Iterator<T>>)delegates.iterator());
    }

    public ComposedIterator(Iterator<? extends Iterator<T>> delegates) {
        this.delegates = delegates;
    }

    @Override
    protected Object computeNextElement() {
        if (this.currentDelegate == null) {
            if (!this.delegates.hasNext()) {
                return END_OF_DATA;
            }
            this.currentDelegate = this.delegates.next();
        }
        if (this.currentDelegate.hasNext()) {
            return this.currentDelegate.next();
        }
        this.currentDelegate = null;
        return this.computeNextElement();
    }

    public static <T> Iterator<T> fromIterables(Collection<? extends Iterable<T>> iterables) {
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
        for (Iterable<T> iterable : iterables) {
            iterators.add(iterable.iterator());
        }
        return new ComposedIterator<T>(iterators.iterator());
    }
}

