/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.custom.CTabETabHelper;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyShowCloseHandler
extends CTabETabHelper
implements ICSSPropertyHandler {
    private static final String CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY = "CSS_CTABFOLDER_SELECTED_SHOW_CLOSE_LISTENER_KEY";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget instanceof CTabItem) {
            Item item = (Item)widget;
            boolean showClose = (Boolean)engine.convert(value, Boolean.class, null);
            if ("selected".equals(pseudo)) {
                Control parent = CSSPropertyShowCloseHandler.getParent(widget);
                ShowCloseSelectionListener listener = (ShowCloseSelectionListener)parent.getData(CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY);
                if (listener == null) {
                    listener = new ShowCloseSelectionListener(engine);
                    parent.addListener(9, (Listener)listener);
                    parent.setData(CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY, (Object)listener);
                } else {
                    listener.setEngine(engine);
                }
                item = CSSPropertyShowCloseHandler.getSelection((Widget)CSSPropertyShowCloseHandler.getParent(widget));
                listener.setSelection(item);
                if (item != null) {
                    CSSPropertyShowCloseHandler.setShowClose(item, showClose);
                }
            } else {
                CSSPropertyShowCloseHandler.setShowClose(item, showClose);
            }
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget instanceof CTabItem) {
            CTabItem item = (CTabItem)widget;
            return Boolean.toString(item.getShowClose());
        }
        return null;
    }

    private static class ShowCloseSelectionListener
    implements Listener {
        private CSSEngine engine;
        private Item selection;

        public ShowCloseSelectionListener(CSSEngine engine) {
            this.engine = engine;
        }

        public void setSelection(Item selection) {
            this.selection = selection;
        }

        public void setEngine(CSSEngine engine) {
            this.engine = engine;
        }

        public void handleEvent(Event e) {
            CSSStyleDeclaration unselectedStyle;
            CSSValue value;
            Item selection = CSSPropertyShowCloseHandler.getSelection(e.widget);
            if (selection == null || selection.isDisposed() || this.selection == selection) {
                return;
            }
            Item[] items = CSSPropertyShowCloseHandler.getItems(e.widget);
            int selectionIndex = CSSPropertyShowCloseHandler.getSelectionIndex(e.widget);
            boolean selectionSet = false;
            CSSStyleDeclaration selectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)selection), "selected");
            if (selectedStyle != null && (value = selectedStyle.getPropertyCSSValue("show-close")) != null) {
                CSSPropertyShowCloseHandler.setShowClose(selection, Boolean.parseBoolean(value.getCssText()));
                selectionSet = true;
            }
            if ((unselectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)selection), null)) == null) {
                int i = 0;
                while (i < items.length) {
                    if (selectionSet && i != selectionIndex) {
                        CSSPropertyShowCloseHandler.setShowClose(items[i], false);
                    }
                    ++i;
                }
            } else {
                CSSValue value2 = unselectedStyle.getPropertyCSSValue("show-close");
                boolean unselectedShowClose = value2 == null ? false : Boolean.parseBoolean(value2.getCssText());
                int i = 0;
                while (i < items.length) {
                    if (selectionSet && i != selectionIndex) {
                        CSSPropertyShowCloseHandler.setShowClose(items[i], unselectedShowClose);
                    }
                    ++i;
                }
            }
            this.selection = selection;
        }
    }
}

