/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.persistence;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.p2.persistence.XMLConstants;
import org.eclipse.equinox.p2.metadata.Version;

public class XMLWriter
implements XMLConstants {
    static final boolean ignoreWhitespace = Boolean.getBoolean("p2.ignoreWhitespace");
    private Stack<String> elements;
    private boolean open;
    private String indent;
    private PrintWriter pw;

    public XMLWriter(OutputStream output, ProcessingInstruction[] piElements) {
        this.pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8)), false);
        this.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.elements = new Stack();
        this.open = false;
        this.indent = "  ";
        if (piElements != null) {
            ProcessingInstruction[] processingInstructionArray = piElements;
            int n = piElements.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessingInstruction piElement = processingInstructionArray[n2];
                this.println(piElement.toString());
                ++n2;
            }
        }
    }

    public void start(String name) {
        if (this.open) {
            this.println('>');
        }
        if (!ignoreWhitespace) {
            this.indent();
        }
        this.print('<');
        this.print(name);
        this.elements.push(name);
        this.open = true;
    }

    public void end(String name) {
        if (this.elements.empty()) {
            throw new EndWithoutStartError();
        }
        int index = this.elements.search(name);
        if (index == -1) {
            throw new EndWithoutStartError(name);
        }
        int i = 0;
        while (i < index) {
            this.end();
            ++i;
        }
    }

    public void end() {
        if (this.elements.empty()) {
            throw new EndWithoutStartError();
        }
        String name = this.elements.pop();
        if (this.open) {
            this.println("/>");
        } else {
            this.printlnIndented("</" + name + '>', false);
        }
        this.open = false;
    }

    /*
     * Unable to fully structure code
     */
    public static String escape(String txt) {
        buffer = null;
        i = 0;
        while (i < txt.length()) {
            block15: {
                c = txt.charAt(i);
                switch (c) {
                    case '<': {
                        replace = "&lt;";
                        break;
                    }
                    case '>': {
                        replace = "&gt;";
                        break;
                    }
                    case '\"': {
                        replace = "&quot;";
                        break;
                    }
                    case '\'': {
                        replace = "&apos;";
                        break;
                    }
                    case '&': {
                        replace = "&amp;";
                        break;
                    }
                    case '\t': {
                        replace = "&#x9;";
                        break;
                    }
                    case '\n': {
                        replace = "&#xA;";
                        break;
                    }
                    case '\r': {
                        replace = "&#xD;";
                        break;
                    }
                    default: {
                        if ((c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) ** GOTO lbl36
                        if (buffer != null) {
                            buffer.append(c);
                        }
                        break block15;
lbl36:
                        // 1 sources

                        v0 = replace = Character.isWhitespace(c) != false ? " " : null;
                    }
                }
                if (buffer == null) {
                    buffer = new StringBuffer(txt.length() + 16);
                    buffer.append(txt.substring(0, i));
                }
                if (replace != null) {
                    buffer.append(replace);
                }
            }
            ++i;
        }
        if (buffer == null) {
            return txt;
        }
        return buffer.toString();
    }

    public void attribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.attribute(name, value);
        }
    }

    public void attribute(String name, boolean value) {
        this.attribute(name, Boolean.toString(value));
    }

    public void attribute(String name, int value) {
        this.attribute(name, Integer.toString(value));
    }

    public void attributeOptional(String name, String value) {
        if (value != null && value.length() > 0) {
            this.attribute(name, value);
        }
    }

    public void attribute(String name, Object value) {
        if (!this.open) {
            throw new AttributeAfterNestedContentError();
        }
        if (value == null) {
            return;
        }
        this.print(' ');
        this.print(name);
        this.print("='");
        this.print(XMLWriter.escape(value.toString()));
        this.print('\'');
    }

    public void cdata(String data) {
        this.cdata(data, true);
    }

    public void cdata(String data, boolean escape) {
        if (this.open) {
            this.println('>');
            this.open = false;
        }
        if (data != null) {
            this.printlnIndented(data, escape);
        }
    }

    public void flush() {
        this.pw.flush();
    }

    public void writeProperties(Map<String, ?> properties) {
        this.writeProperties("properties", properties);
    }

    public void writeProperties(String propertiesElement, Map<String, ?> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.start(propertiesElement);
        this.attribute("size", properties.size());
        properties.forEach(this::writeProperty);
        this.end();
    }

    public void writeProperty(String name, Object value) {
        String valueStr;
        String type;
        if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection coll = (Collection)value;
            type = PROPERTY_TYPE_LIST;
            String elType = this.resolvePropertyType(coll.iterator().next());
            if (elType != null) {
                type = String.valueOf(type) + String.format("<%s>", elType);
            }
            valueStr = coll.stream().map(Object::toString).collect(Collectors.joining(","));
        } else {
            type = this.resolvePropertyType(value);
            valueStr = value.toString();
        }
        this.start("property");
        this.attribute("name", name);
        this.attribute("value", valueStr);
        this.attributeOptional("type", type);
        this.end();
    }

    private String resolvePropertyType(Object value) {
        if (value instanceof Integer) {
            return PROPERTY_TYPE_INTEGER;
        }
        if (value instanceof Long) {
            return PROPERTY_TYPE_LONG;
        }
        if (value instanceof Float) {
            return PROPERTY_TYPE_FLOAT;
        }
        if (value instanceof Double) {
            return PROPERTY_TYPE_DOUBLE;
        }
        if (value instanceof Byte) {
            return PROPERTY_TYPE_BYTE;
        }
        if (value instanceof Short) {
            return PROPERTY_TYPE_SHORT;
        }
        if (value instanceof Character) {
            return PROPERTY_TYPE_CHARACTER;
        }
        if (value instanceof Boolean) {
            return PROPERTY_TYPE_BOOLEAN;
        }
        if (value instanceof Version) {
            return PROPERTY_TYPE_VERSION;
        }
        return null;
    }

    protected static String attributeImage(String name, String value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(name) + "='" + XMLWriter.escape(value) + '\'';
    }

    private void println(char c) {
        if (ignoreWhitespace) {
            this.pw.print(c);
        } else {
            this.pw.println(c);
        }
    }

    private void println(String s) {
        if (ignoreWhitespace) {
            this.pw.print(s);
        } else {
            this.pw.println(s);
        }
    }

    private void println() {
        if (!ignoreWhitespace) {
            this.pw.println();
        }
    }

    private void print(char c) {
        this.pw.print(c);
    }

    private void print(String s) {
        this.pw.print(s);
    }

    private void printlnIndented(String s, boolean escape) {
        if (s.length() == 0) {
            this.println();
        } else {
            if (!ignoreWhitespace) {
                this.indent();
            }
            this.println(escape ? XMLWriter.escape(s) : s);
        }
    }

    private void indent() {
        if (!ignoreWhitespace) {
            int i = this.elements.size();
            while (i > 0) {
                this.print(this.indent);
                --i;
            }
        }
    }

    public static class AttributeAfterNestedContentError
    extends Error {
        private static final long serialVersionUID = 1L;
    }

    public static class EndWithoutStartError
    extends Error {
        private static final long serialVersionUID = 1L;
        private String name;

        public EndWithoutStartError() {
        }

        public EndWithoutStartError(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ProcessingInstruction {
        private String target;
        private String[] data;
        public static final String XML_UTF8 = "<?xml version='1.0' encoding='UTF-8'?>";

        public ProcessingInstruction(String target, String[] attrs, String[] values) {
            this.target = target;
            this.data = new String[attrs.length];
            int i = 0;
            while (i < attrs.length) {
                this.data[i] = XMLWriter.attributeImage(attrs[i], values[i]);
                ++i;
            }
        }

        public static ProcessingInstruction makeTargetVersionInstruction(String target, Version version) {
            return new ProcessingInstruction(target, new String[]{"version"}, new String[]{version.toString()});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<?");
            sb.append(this.target).append(' ');
            int i = 0;
            while (i < this.data.length) {
                sb.append(this.data[i]);
                if (i < this.data.length - 1) {
                    sb.append(' ');
                }
                ++i;
            }
            sb.append("?>");
            return sb.toString();
        }
    }
}

