/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public final class ServiceLocator
implements IDisposable,
INestable,
IServiceLocator {
    boolean activated = false;
    private final AbstractServiceFactory factory;
    private final IServiceLocator parent;
    private volatile boolean disposed;
    private IDisposable owner;
    private volatile IEclipseContext e4Context;
    private final Map<Class<?>, Object> services = new ConcurrentHashMap();

    public ServiceLocator() {
        this(null, null, null);
    }

    public ServiceLocator(IServiceLocator parent, AbstractServiceFactory factory, IDisposable owner) {
        this.parent = parent;
        this.factory = factory;
        this.owner = owner;
    }

    @Override
    public void activate() {
        this.activated = true;
        for (final Object service : this.services.values()) {
            if (!(service instanceof INestable)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((INestable)service).activate();
                }

                public void handleException(Throwable ex) {
                    WorkbenchPlugin.log(StatusUtil.newStatus(4, "Error while activating: " + service, ex));
                }
            });
        }
    }

    @Override
    public void deactivate() {
        this.activated = false;
        for (final Object service : this.services.values()) {
            if (!(service instanceof INestable)) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((INestable)service).deactivate();
                }

                public void handleException(Throwable ex) {
                    WorkbenchPlugin.log(StatusUtil.newStatus(4, "Error while deactivating: " + service, ex));
                }
            });
        }
    }

    @Override
    public void dispose() {
        this.disposeServices();
        if (this.services.size() > 0) {
            this.disposeServices();
        }
        if (this.services.size() > 0) {
            WorkbenchPlugin.log(StatusUtil.newStatus(2, String.format("Services: %s register themselves while disposing (skipping dispose of such services).", this.services), null));
        }
        this.services.clear();
        this.disposed = true;
        this.e4Context = null;
        this.owner = null;
    }

    private void disposeServices() {
        Iterator<Map.Entry<Class<?>, Object>> iterator = this.services.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, Object> entry = iterator.next();
            if (entry.getValue() instanceof IDisposable) {
                final IDisposable iDisposable = (IDisposable)entry.getValue();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        iDisposable.dispose();
                    }

                    public void handleException(Throwable ex) {
                        WorkbenchPlugin.log(StatusUtil.newStatus(4, "Error while disposing: " + iDisposable.getClass().getName(), ex));
                    }
                });
            }
            iterator.remove();
        }
    }

    @Override
    public <T> T getService(Class<T> key) {
        IEclipseContext context = this.e4Context;
        if (context == null) {
            return null;
        }
        if (IEclipseContext.class.equals(key)) {
            return key.cast(context);
        }
        Object service = context.get(key.getName());
        if (service == null) {
            service = this.services.get(key);
        } else if (service == context.getLocal(key.getName())) {
            this.registerService(key, service, false);
        }
        if (service == null) {
            IServiceLocator factoryParent = WorkbenchServiceRegistry.GLOBAL_PARENT;
            if (this.parent != null) {
                factoryParent = new ParentLocator(this.parent, key);
            }
            if (this.factory != null) {
                service = this.factory.create(key, factoryParent, this);
            }
            if (service == null) {
                service = WorkbenchServiceRegistry.getRegistry().getService(key, factoryParent, this);
            }
            if (service == null) {
                service = factoryParent.getService(key);
            } else {
                this.registerService(key, service, true);
            }
        }
        return key.cast(service);
    }

    @Override
    public boolean hasService(Class<?> key) {
        IEclipseContext context = this.e4Context;
        if (context == null) {
            return false;
        }
        return context.containsKey(key.getName());
    }

    public void registerService(Class api, Object service) {
        this.registerService(api, service, true);
    }

    private void registerService(Class<?> api, Object service, boolean saveInContext) {
        if (api == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        if (!api.isInstance(service)) {
            throw new IllegalArgumentException("The service does not implement the given interface");
        }
        if (this.isDisposed()) {
            IllegalStateException ex = new IllegalStateException("An attempt was made to register service " + service + " with implementation class " + api + " on a disposed service locator");
            WorkbenchPlugin.log(StatusUtil.newStatus(4, ex.getMessage(), (Throwable)ex));
            return;
        }
        if (service instanceof INestable && this.activated) {
            ((INestable)service).activate();
        }
        this.services.put(api, service);
        if (saveInContext) {
            IEclipseContext context = this.e4Context;
            if (context == null) {
                return;
            }
            context.set(api.getName(), service);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void unregisterServices(String[] serviceNames) {
        if (this.owner != null) {
            this.owner.dispose();
        }
    }

    public void setContext(IEclipseContext context) {
        this.e4Context = context;
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }

    private static class ParentLocator
    implements IServiceLocator {
        private IServiceLocator locator;
        private Class<?> key;

        public ParentLocator(IServiceLocator parent, Class<?> serviceInterface) {
            this.locator = parent;
            this.key = serviceInterface;
        }

        @Override
        public <T> T getService(Class<T> api) {
            if (this.key.equals(api)) {
                return api.cast(this.locator.getService(this.key));
            }
            return null;
        }

        @Override
        public boolean hasService(Class<?> api) {
            return this.key.equals(api);
        }
    }
}

