/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.Messages;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OS {
    public static final OS INSTANCE = OS.create();
    public static final List<OS> INSTANCES = OS.createAll();
    private final String osgiOS;
    private final String osgiWS;
    private final String osgiArch;

    protected OS(String osgiOS, String osgiWS, String osgiArch) {
        this.osgiOS = osgiOS;
        this.osgiWS = osgiWS;
        this.osgiArch = osgiArch;
    }

    public String getOsgiOS() {
        return this.osgiOS;
    }

    public String getOsgiWS() {
        return this.osgiWS;
    }

    public String getOsgiArch() {
        return this.osgiArch;
    }

    public boolean isWin() {
        return false;
    }

    public boolean isMac() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isCurrent() {
        return Platform.getOS().equals(this.osgiOS) && Platform.getWS().equals(this.osgiWS) && Platform.getOSArch().equals(this.osgiArch);
    }

    public boolean isCurrentOS() {
        return Platform.getOS().equals(this.osgiOS);
    }

    public boolean is32BitAvailable() {
        return true;
    }

    public int getBitness() {
        String osgiArch = this.getOsgiArch();
        if ("x86".equals(osgiArch)) {
            return 32;
        }
        return 64;
    }

    public boolean isLineEndingConversionNeeded() {
        return false;
    }

    protected String getEncoding() {
        return "ISO-8859-1";
    }

    protected abstract String[] getOpenCommands();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openSystemBrowser(String url) {
        try {
            String[] stringArray = this.getOpenCommands();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                if (this.openSystemBrowser(command, url)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable command) {
            // empty catch block
        }
        try {
            Class desktopClass = CommonPlugin.loadClass((String)UtilPlugin.INSTANCE.getSymbolicName(), (String)"java.awt.Desktop");
            Method getDesktopMethod = ReflectUtil.getMethod(desktopClass, "getDesktop", new Class[0]);
            Method browseMethod = ReflectUtil.getMethod(desktopClass, "browse", URI.class);
            Object desktop = getDesktopMethod.invoke(null, new Object[0]);
            browseMethod.invoke(desktop, new URI(url));
            return true;
        }
        catch (Throwable ex) {
            UtilPlugin.INSTANCE.log(ex, 2);
            return false;
        }
    }

    private boolean openSystemBrowser(String command, String url) {
        if (IOUtil.getFromPath(command) != null) {
            String[] cmdarray = new String[]{command, url};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                if (process != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public Process execute(List<String> command, boolean terminal) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Map<String, String> environment = processBuilder.environment();
            environment.remove("SWT_GTK3");
        }
        catch (UnsupportedOperationException environment) {
            // empty catch block
        }
        Process process = processBuilder.start();
        process.getInputStream().close();
        process.getOutputStream().close();
        process.getErrorStream().close();
        return process;
    }

    protected String getCommandLine(List<String> command) {
        StringBuilder builder = new StringBuilder();
        for (String token : command) {
            if (builder.length() != 0) {
                builder.append(' ');
            }
            builder.append('\"');
            builder.append(token);
            builder.append('\"');
        }
        return builder.toString();
    }

    public String getRelativeProductFolder(String folderName) {
        if (StringUtil.isEmpty(folderName)) {
            return "eclipse";
        }
        return folderName;
    }

    public abstract String getRelativeExecutableFolder();

    public String getExecutableName(String launcherName) {
        return launcherName;
    }

    public static String getCurrentLauncher(boolean console) {
        try {
            File launcherFile;
            String launcher = PropertiesUtil.getProperty("eclipse.launcher");
            if (launcher != null && (launcherFile = new File(launcher)).isFile()) {
                File consoleLauncher;
                File parentFolder;
                File result = IOUtil.getCanonicalFile(launcherFile);
                if (INSTANCE.isWin() && console && (parentFolder = result.getParentFile()) != null && (consoleLauncher = new File(parentFolder, "eclipsec.exe")).isFile()) {
                    return consoleLauncher.getPath();
                }
                return result.getPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public abstract String getGitPrefix();

    public abstract String getJREsRoot();

    public abstract OS getForBitness(int var1);

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static OS create() {
        String os = Platform.getOS();
        String ws = Platform.getWS();
        String arch = Platform.getOSArch();
        if ("win32".equals(os)) {
            if ("x86_64".equals(arch)) {
                return new Win64(ws);
            }
            return new Win32(ws, arch);
        }
        if ("macosx".equals(os)) {
            return new Mac(ws, arch);
        }
        if ("linux".equals(os)) {
            return new Linux(ws, arch);
        }
        throw new IllegalStateException(NLS.bind((String)Messages.OS_OS_NotSupported_exception, (Object)os));
    }

    private static List<OS> createAll() {
        ArrayList<OS> result = new ArrayList<OS>();
        result.add(Win64.INSTANCE);
        result.add(Win32.INSTANCE);
        result.add(new Mac("cocoa", "x86_64"));
        result.add(new Linux("gtk", "x86_64"));
        result.add(new Linux("gtk", "x86"));
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return String.valueOf(this.getOsgiOS()) + " " + this.getOsgiWS() + " " + this.getOsgiArch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Linux
    extends OS {
        private static final String[] OPEN_COMMANDS = new String[]{"kde-open", "gnome-open", "xdg-open", "sensible-browser"};
        private static final String[] TERMINAL_COMMANDS = new String[]{"gnome-terminal", "xterm"};

        public Linux(String osgiWS, String osgiArch) {
            super("linux", osgiWS, osgiArch);
        }

        @Override
        public boolean isLinux() {
            return true;
        }

        @Override
        public String getRelativeExecutableFolder() {
            return "";
        }

        @Override
        public String getGitPrefix() {
            return "";
        }

        @Override
        public String getJREsRoot() {
            return "";
        }

        @Override
        public OS getForBitness(int bitness) {
            String osgiArch = this.getOsgiArch();
            if (bitness == 32) {
                if ("x86_64".equals(osgiArch)) {
                    return this.createLinux("x86");
                }
            } else if ("x86".equals(osgiArch)) {
                return this.createLinux("x86_64");
            }
            return this;
        }

        @Override
        public Process execute(List<String> command, boolean terminal) throws Exception {
            if (terminal) {
                String commandLine = this.getCommandLine(command);
                String[] stringArray = TERMINAL_COMMANDS;
                int n = TERMINAL_COMMANDS.length;
                int n2 = 0;
                while (n2 < n) {
                    String xterm = stringArray[n2];
                    try {
                        ArrayList<String> terminalCommand = new ArrayList<String>();
                        terminalCommand.add(xterm);
                        terminalCommand.add("-e");
                        terminalCommand.add(commandLine);
                        return super.execute(terminalCommand, true);
                    }
                    catch (Exception exception) {
                        ++n2;
                    }
                }
                throw new IOException(NLS.bind((String)Messages.OS_CannotStartTerminal_exception, (Object[])new Object[]{TERMINAL_COMMANDS}));
            }
            return super.execute(command, false);
        }

        @Override
        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }

        private Linux createLinux(String arch) {
            return new Linux(this.getOsgiWS(), arch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mac
    extends OS {
        private static final String[] OPEN_COMMANDS = new String[]{"open"};

        public Mac(String osgiWS, String osgiArch) {
            super("macosx", osgiWS, osgiArch);
        }

        @Override
        public boolean isMac() {
            return true;
        }

        @Override
        public String getRelativeProductFolder(String folderName) {
            if (StringUtil.isEmpty(folderName)) {
                folderName = "Eclipse.app";
            } else if (!folderName.endsWith(".app")) {
                folderName = String.valueOf(folderName) + ".app";
            }
            return String.valueOf(folderName) + "/Contents/Eclipse";
        }

        @Override
        public String getRelativeExecutableFolder() {
            return "../MacOS";
        }

        @Override
        public String getGitPrefix() {
            return "/";
        }

        @Override
        public String getJREsRoot() {
            return "/";
        }

        @Override
        public boolean is32BitAvailable() {
            return false;
        }

        @Override
        public OS getForBitness(int bitness) {
            return this;
        }

        @Override
        public Process execute(List<String> command, boolean terminal) throws Exception {
            if (terminal) {
                File commandFile = File.createTempFile("cmd-", "");
                commandFile.deleteOnExit();
                String commandPath = commandFile.toString();
                String commandLine = this.getCommandLine(command);
                IOUtil.writeUTF8(commandFile, commandLine);
                ArrayList<String> chmodCommand = new ArrayList<String>();
                chmodCommand.add("chmod");
                chmodCommand.add("a+x");
                chmodCommand.add(commandPath);
                ProcessBuilder chmodProcessBuilder = new ProcessBuilder(chmodCommand);
                Process chmodProcess = chmodProcessBuilder.start();
                chmodProcess.waitFor();
                ArrayList<String> terminalCommand = new ArrayList<String>();
                terminalCommand.add("open");
                terminalCommand.add("-b");
                terminalCommand.add("com.apple.terminal");
                terminalCommand.add(commandPath);
                command = terminalCommand;
            }
            return super.execute(command, terminal);
        }

        @Override
        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Win32
    extends OS {
        private static final Win32 INSTANCE = new Win32("win32", "x86");
        private static final String[] OPEN_COMMANDS = new String[0];

        public Win32(String osgiWS, String osgiArch) {
            super("win32", osgiWS, osgiArch);
        }

        @Override
        public boolean isWin() {
            return true;
        }

        @Override
        public boolean isLineEndingConversionNeeded() {
            return true;
        }

        @Override
        public String getRelativeExecutableFolder() {
            return "";
        }

        @Override
        public String getExecutableName(String launcherName) {
            return String.valueOf(super.getExecutableName(launcherName)) + ".exe";
        }

        @Override
        public String getGitPrefix() {
            return "C:\\Program Files (x86)\\Git";
        }

        @Override
        public String getJREsRoot() {
            return "C:\\Program Files (x86)\\Java";
        }

        @Override
        public OS getForBitness(int bitness) {
            if (bitness == 64) {
                return Win64.INSTANCE;
            }
            return this;
        }

        @Override
        public Process execute(List<String> command, boolean terminal) throws Exception {
            if (terminal) {
                ArrayList<String> terminalCommand = new ArrayList<String>();
                terminalCommand.add("cmd");
                terminalCommand.add("/C");
                terminalCommand.add("start");
                terminalCommand.addAll(command);
                command = terminalCommand;
            }
            return super.execute(command, terminal);
        }

        @Override
        protected String[] getOpenCommands() {
            return OPEN_COMMANDS;
        }
    }

    private static class Win64
    extends Win32 {
        private static final Win64 INSTANCE = new Win64("win32");

        public Win64(String osgiWS) {
            super(osgiWS, "x86_64");
        }

        public String getJREsRoot() {
            return "C:\\Program Files\\Java";
        }

        public OS getForBitness(int bitness) {
            if (bitness == 32) {
                return Win32.INSTANCE;
            }
            return this;
        }
    }
}

