/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.Path;
import org.eclipse.urischeme.internal.registration.IWinRegistry;
import org.eclipse.urischeme.internal.registration.WinRegistryException;

public class WinRegistry
implements IWinRegistry {
    private static final Preferences USER_ROOT = Preferences.userRoot();
    private static final int KEY_READ = 1;
    private static final int KEY_SET = 2;
    private static final int KEY_DELETE = 65536;
    private static Method METHOD_stringToByteArray;
    private static Method METHOD_WinRegQueryValueEx;
    private static Method METHOD_toJavaValueString;
    private static Method METHOD_openKey;
    private static Method METHOD_closeKey;
    private static Method METHOD_WinRegSetValueEx1;
    private static Method METHOD_WinRegDeleteKey;

    static {
        try {
            Class<?> prefClass = USER_ROOT.getClass();
            METHOD_stringToByteArray = prefClass.getDeclaredMethod("stringToByteArray", String.class);
            METHOD_toJavaValueString = prefClass.getDeclaredMethod("toJavaValueString", byte[].class);
            METHOD_openKey = prefClass.getDeclaredMethod("openKey", byte[].class, Integer.TYPE, Integer.TYPE);
            Class<Number> parameterType = Integer.TYPE;
            try {
                METHOD_closeKey = prefClass.getDeclaredMethod("closeKey", parameterType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                parameterType = Long.TYPE;
                METHOD_closeKey = prefClass.getDeclaredMethod("closeKey", parameterType);
            }
            METHOD_WinRegQueryValueEx = prefClass.getDeclaredMethod("WindowsRegQueryValueEx", parameterType, byte[].class);
            METHOD_WinRegSetValueEx1 = prefClass.getDeclaredMethod("WindowsRegSetValueEx1", parameterType, byte[].class, byte[].class);
            METHOD_WinRegDeleteKey = prefClass.getDeclaredMethod("WindowsRegDeleteKey", parameterType, byte[].class);
            AccessibleObject[] allMethods = new AccessibleObject[]{METHOD_stringToByteArray, METHOD_toJavaValueString, METHOD_openKey, METHOD_closeKey, METHOD_WinRegQueryValueEx, METHOD_WinRegSetValueEx1, METHOD_WinRegDeleteKey};
            AccessibleObject.setAccessible(allMethods, true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setValueForKey(String key, String attribute, String value) throws WinRegistryException {
        try {
            Object handle = METHOD_openKey.invoke((Object)USER_ROOT, WinRegistry.toByteArray(key), 2, 2);
            int result = (Integer)METHOD_WinRegSetValueEx1.invoke(null, handle, WinRegistry.toByteArray(attribute), WinRegistry.toByteArray(value));
            METHOD_closeKey.invoke((Object)USER_ROOT, handle);
            if (result != 0) {
                throw new WinRegistryException("Unable to write to registry. Key = " + key + attribute + ", value: " + value);
            }
        }
        catch (Exception e) {
            throw new WinRegistryException(e.getMessage(), e);
        }
    }

    @Override
    public String getValueForKey(String key, String attribute) throws WinRegistryException {
        try {
            Object handle = METHOD_openKey.invoke((Object)USER_ROOT, WinRegistry.toByteArray(key), 1, 1);
            byte[] valb = (byte[])METHOD_WinRegQueryValueEx.invoke(null, handle, WinRegistry.toByteArray(attribute));
            METHOD_closeKey.invoke((Object)USER_ROOT, handle);
            return valb != null ? WinRegistry.toString(valb) : null;
        }
        catch (Exception e) {
            throw new WinRegistryException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteKey(String key) throws WinRegistryException {
        try {
            Path keyPath = new Path(key);
            String parent = keyPath.removeLastSegments(1).toOSString();
            String child = keyPath.lastSegment();
            Object parentHandle = METHOD_openKey.invoke((Object)USER_ROOT, WinRegistry.toByteArray(parent), 65536, 65536);
            int result = (Integer)METHOD_WinRegDeleteKey.invoke(null, parentHandle, WinRegistry.toByteArray(child));
            METHOD_closeKey.invoke((Object)USER_ROOT, parentHandle);
            if (result != 0) {
                throw new WinRegistryException("Unable to delete key = " + keyPath);
            }
        }
        catch (Exception e) {
            throw new WinRegistryException(e.getMessage(), e);
        }
    }

    private static byte[] toByteArray(String str) {
        if (str == null) {
            return new byte[1];
        }
        try {
            return (byte[])METHOD_stringToByteArray.invoke(null, str);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static String byteArrayToString(byte[] array) throws UnsupportedEncodingException {
        String result;
        byte[] truncatedArray = new byte[array.length - 1];
        System.arraycopy(array, 0, truncatedArray, 0, truncatedArray.length);
        try {
            result = new String(truncatedArray, "Windows-1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = new String(truncatedArray, "ISO-8859-1");
        }
        return result;
    }

    private static String toString(byte[] bytes) {
        try {
            return WinRegistry.byteArrayToString(bytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

