/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.eclipse.core.databinding.conversion.Converter;

public class NumberToStringConverter
extends Converter<Object, String> {
    private final NumberFormat numberFormat;
    private final Class<?> fromType;
    private boolean fromTypeFitsLong;
    private boolean fromTypeIsDecimalType;
    private boolean fromTypeIsBigInteger;
    private boolean fromTypeIsBigDecimal;
    static Class<?> icuBigDecimal = null;
    static Constructor<?> icuBigDecimalCtr = null;

    private NumberToStringConverter(NumberFormat numberFormat, Class<?> fromType) {
        super(fromType, String.class);
        try {
            icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            icuBigDecimalCtr = icuBigDecimal.getConstructor(BigInteger.class, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {}
        this.numberFormat = Objects.requireNonNull(numberFormat);
        this.fromType = Objects.requireNonNull(fromType);
        if (Integer.class.equals(fromType) || Integer.TYPE.equals(fromType) || Long.class.equals(fromType) || Long.TYPE.equals(fromType) || Short.class.equals(fromType) || Short.TYPE.equals(fromType) || Byte.class.equals(fromType) || Byte.TYPE.equals(fromType)) {
            this.fromTypeFitsLong = true;
        } else if (Float.class.equals(fromType) || Float.TYPE.equals(fromType) || Double.class.equals(fromType) || Double.TYPE.equals(fromType)) {
            this.fromTypeIsDecimalType = true;
        } else if (BigInteger.class.equals(fromType)) {
            this.fromTypeIsBigInteger = true;
        } else if (BigDecimal.class.equals(fromType)) {
            this.fromTypeIsBigDecimal = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(Object fromObject) {
        if (fromObject == null && !this.fromType.isPrimitive()) {
            return "";
        }
        Number number = (Number)fromObject;
        String result = null;
        if (this.fromTypeFitsLong) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format(number.longValue());
            }
        }
        if (this.fromTypeIsDecimalType) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format(number.doubleValue());
            }
        }
        if (this.fromTypeIsBigInteger) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format((BigInteger)number);
            }
        }
        if (this.fromTypeIsBigDecimal) {
            if (icuBigDecimal != null && icuBigDecimalCtr != null && this.numberFormat instanceof DecimalFormat) {
                BigDecimal o = (BigDecimal)fromObject;
                try {
                    fromObject = icuBigDecimalCtr.newInstance(o.unscaledValue(), o.scale());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {}
            }
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format(fromObject);
            }
        }
        return result;
    }

    public static NumberToStringConverter fromDouble(boolean primitive) {
        return NumberToStringConverter.fromDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static NumberToStringConverter fromDouble(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Double.TYPE : Double.class);
    }

    public static NumberToStringConverter fromLong(boolean primitive) {
        return NumberToStringConverter.fromLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromLong(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Long.TYPE : Long.class);
    }

    public static NumberToStringConverter fromFloat(boolean primitive) {
        return NumberToStringConverter.fromFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static NumberToStringConverter fromFloat(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Float.TYPE : Float.class);
    }

    public static NumberToStringConverter fromInteger(boolean primitive) {
        return NumberToStringConverter.fromInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromInteger(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Integer.TYPE : Integer.class);
    }

    public static NumberToStringConverter fromBigInteger() {
        return NumberToStringConverter.fromBigInteger(NumberFormat.getIntegerInstance());
    }

    public static NumberToStringConverter fromBigInteger(NumberFormat numberFormat) {
        return new NumberToStringConverter(numberFormat, BigInteger.class);
    }

    public static NumberToStringConverter fromBigDecimal() {
        return NumberToStringConverter.fromBigDecimal(NumberFormat.getNumberInstance());
    }

    public static NumberToStringConverter fromBigDecimal(NumberFormat numberFormat) {
        return new NumberToStringConverter(numberFormat, BigDecimal.class);
    }

    public static NumberToStringConverter fromShort(boolean primitive) {
        return NumberToStringConverter.fromShort(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromShort(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Short.TYPE : Short.class);
    }

    public static NumberToStringConverter fromByte(boolean primitive) {
        return NumberToStringConverter.fromByte(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromByte(NumberFormat numberFormat, boolean primitive) {
        return new NumberToStringConverter(numberFormat, primitive ? Byte.TYPE : Byte.class);
    }
}

