/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.PartSelectionListener;

public class SelectionListenerFactory {
    public static ISelectionListener createListener(IWorkbenchPart part, Predicate<ISelectionModel> predicate) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull(predicate);
        return new PartSelectionListener(part, (ISelectionListener)((Object)part), predicate);
    }

    public static ISelectionListener createListener(IWorkbenchPart part, ISelectionListener listener, Predicate<ISelectionModel> predicate) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull(predicate);
        return new PartSelectionListener(part, listener, predicate);
    }

    public static ISelectionListener createVisibleListener(IWorkbenchPart part, ISelectionListener listener) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)listener);
        return new PartSelectionListener(part, listener, Predicates.alreadyDelivered.and(Predicates.targetPartVisible));
    }

    public static ISelectionListener createVisibleListener(IWorkbenchPart part, ISelectionListener listener, Predicate<ISelectionModel> additionalPredicate) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull(additionalPredicate);
        return SelectionListenerFactory.decorate(SelectionListenerFactory.createVisibleListener(part, listener), additionalPredicate);
    }

    public static ISelectionListener createVisibleSelfMutedListener(IWorkbenchPart part, ISelectionListener listener) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)listener);
        return new PartSelectionListener(part, listener, Predicates.alreadyDeliveredAnyPart.and(Predicates.targetPartVisible).and(Predicates.selfMute));
    }

    public static ISelectionListener createVisibleSelfMutedListener(IWorkbenchPart part, ISelectionListener listener, Predicate<ISelectionModel> additionalPredicate) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull(additionalPredicate);
        return SelectionListenerFactory.decorate(SelectionListenerFactory.createVisibleSelfMutedListener(part, listener), additionalPredicate);
    }

    public static ISelectionListener decorate(ISelectionListener listener, Predicate<ISelectionModel> additionalPredicate) {
        Assert.isNotNull(additionalPredicate);
        if (listener instanceof PartSelectionListener) {
            return ((PartSelectionListener)listener).addPredicate(additionalPredicate);
        }
        return listener;
    }

    public static interface ISelectionModel {
        public IWorkbenchPart getTargetPart();

        public ISelection getCurrentSelection();

        public IWorkbenchPart getCurrentSelectionPart();

        public ISelection getLastDeliveredSelection();

        public IWorkbenchPart getLastDeliveredSelectionPart();

        public boolean isTargetPartVisible();

        public boolean isSelectionPartVisible();
    }

    public static class Predicates {
        public static Predicate<ISelectionModel> emptySelection = model -> model.getCurrentSelection() != null && !model.getCurrentSelection().isEmpty();
        public static Predicate<ISelectionModel> selectionPartVisible = model -> model.isSelectionPartVisible();
        public static Predicate<ISelectionModel> alreadyDelivered = model -> !Objects.equals(model.getCurrentSelectionPart(), model.getLastDeliveredSelectionPart()) || !Objects.equals(model.getCurrentSelection(), model.getLastDeliveredSelection());
        public static Predicate<ISelectionModel> alreadyDeliveredAnyPart = model -> !Objects.equals(model.getCurrentSelection(), model.getLastDeliveredSelection());
        public static Predicate<ISelectionModel> selfMute = model -> model.getCurrentSelectionPart() != model.getTargetPart();
        public static Predicate<ISelectionModel> targetPartVisible = model -> model.isTargetPartVisible();

        public static Predicate<ISelectionModel> selectionType(Class<? extends ISelection> selectionType) {
            return model -> model.getCurrentSelection() != null && selectionType.isAssignableFrom(model.getCurrentSelection().getClass());
        }

        public static Predicate<ISelectionModel> selectionSize(int size) {
            return model -> model.getCurrentSelection() instanceof IStructuredSelection && ((IStructuredSelection)model.getCurrentSelection()).size() == size;
        }

        public static Predicate<ISelectionModel> minimalSelectionSize(int size) {
            return model -> model.getCurrentSelection() instanceof IStructuredSelection && ((IStructuredSelection)model.getCurrentSelection()).size() >= size;
        }

        public static Predicate<ISelectionModel> adaptsTo(Class<?> adapterType) {
            return model -> {
                if (!(model.getCurrentSelection() instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection sel = (IStructuredSelection)model.getCurrentSelection();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (Adapters.adapt((Object)object, (Class)adapterType) == null) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            };
        }
    }
}

