/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.oomph.internal.util.UtilPlugin;

public class OfflineMode {
    private static final String COMMAND_ID = "org.eclipse.oomph.ui.ToggleOfflineMode";
    private static boolean initializedToggleStateAccessor;

    public static boolean isEnabled() {
        try {
            UtilPlugin.ToggleStateAccessor toggleStateAccessor = UtilPlugin.getToggleStateAccessor();
            return toggleStateAccessor.isEnabled(COMMAND_ID);
        }
        catch (Exception exception) {
            return UtilPlugin.DEFAULT_TOGGLE_STATE_ACCESSOR.isEnabled(COMMAND_ID);
        }
    }

    public static void setEnabled(boolean enabled) {
        if (!initializedToggleStateAccessor) {
            OfflineMode.injectUILevelAccessor();
            initializedToggleStateAccessor = true;
        }
        try {
            UtilPlugin.ToggleStateAccessor toggleStateAccessor = UtilPlugin.getToggleStateAccessor();
            toggleStateAccessor.setEnabled(COMMAND_ID, enabled);
        }
        catch (Exception exception) {
            UtilPlugin.DEFAULT_TOGGLE_STATE_ACCESSOR.setEnabled(COMMAND_ID, enabled);
        }
    }

    private static void injectUILevelAccessor() {
        try {
            CommonPlugin.loadClass((String)"org.eclipse.oomph.ui", (String)"org.eclipse.oomph.internal.ui.UIPlugin");
        }
        catch (Throwable throwable) {}
    }
}

