/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.presentation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetGroup;
import org.eclipse.oomph.workingsets.presentation.WorkingSetsEditorPlugin;
import org.eclipse.oomph.workingsets.util.WorkingSetsUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetManager {
    private static final String WORKING_SET_PAGE = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    private static final String PACKAGE_EXPLORER_ID = "org.eclipse.jdt.ui.PackageExplorer";
    private static final IWorkingSetManager MANAGER = PlatformUI.getWorkbench().getWorkingSetManager();
    private static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();
    public static final WorkingSetManager INSTANCE = new WorkingSetManager();
    private final IEclipsePreferences.IPreferenceChangeListener preferencesListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("working.set.group".equals(event.getKey())) {
                WorkingSetManager.this.apply();
            }
        }
    };
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            if (!WorkingSetManager.this.workingSetGroup.getWorkingSets().isEmpty() && (delta = event.getDelta()) != null) {
                try {
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        List<IProject> addedProjects = new ArrayList<IProject>();
                        List<IProject> removedProjects = new ArrayList<IProject>();

                        ResourceDeltaVisitor() {
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource instanceof IWorkspaceRoot) {
                                return true;
                            }
                            if (resource instanceof IProject) {
                                IProject project;
                                int kind = delta.getKind();
                                if (kind == 1) {
                                    IProject project2 = (IProject)resource;
                                    if (!project2.isHidden()) {
                                        this.addedProjects.add(project2);
                                    }
                                } else if (kind == 2 && !(project = (IProject)resource).isHidden()) {
                                    this.removedProjects.remove(project);
                                }
                            }
                            return false;
                        }
                    }
                    ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                    WorkingSetManager.this.updateProjects(resourceDeltaVisitor.addedProjects, resourceDeltaVisitor.removedProjects);
                }
                catch (CoreException coreException) {}
            }
        }
    };
    private WorkingSetGroup workingSetGroup = WorkingSetsUtil.getWorkingSetGroup();

    public WorkingSetManager() {
        WORKSPACE.addResourceChangeListener(this.resourceChangeListener);
        WorkingSetsUtil.WORKING_SET_GROUP_PREFERENCES.addPreferenceChangeListener(this.preferencesListener);
    }

    public void dispose() {
        WORKSPACE.removeResourceChangeListener(this.resourceChangeListener);
        WorkingSetsUtil.WORKING_SET_GROUP_PREFERENCES.removePreferenceChangeListener(this.preferencesListener);
    }

    private EMap<String, Set<IAdaptable>> getWorkingSets() {
        BasicEMap workingSets = new BasicEMap();
        for (WorkingSet workingSet : this.workingSetGroup.getWorkingSets()) {
            String name;
            IWorkingSet iWorkingSet = MANAGER.getWorkingSet(name = workingSet.getName());
            workingSets.put((Object)name, iWorkingSet == null ? new LinkedHashSet() : new LinkedHashSet<IAdaptable>(Arrays.asList(iWorkingSet.getElements())));
        }
        return workingSets;
    }

    private void apply(EMap<String, Set<IAdaptable>> workingSets) {
        for (Map.Entry entry : workingSets) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            IWorkingSet workingSet = MANAGER.getWorkingSet(key);
            if (workingSet == null) {
                if (key == null || value == null) continue;
                workingSet = MANAGER.createWorkingSet(key, value.toArray(new IAdaptable[value.size()]));
                workingSet.setLabel(key);
                workingSet.setId(WORKING_SET_PAGE);
                MANAGER.addWorkingSet(workingSet);
                continue;
            }
            if (value == null) {
                MANAGER.removeWorkingSet(workingSet);
                continue;
            }
            workingSet.setElements(value.toArray(new IAdaptable[value.size()]));
        }
        this.managePackageExplorer(true);
    }

    private void managePackageExplorer(boolean addListener) {
        if (WORKSPACE.getRoot().getProjects().length != 0) {
            try {
                boolean handledNavigator = false;
                boolean handledPackageExplorer = false;
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewPart packageExplorer;
                        IViewPart commonNavigator;
                        IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                        if (!handledNavigator && (commonNavigator = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer")) != null) {
                            handledNavigator = true;
                            Method getNavigatorActionServiceMethod = commonNavigator.getClass().getMethod("getNavigatorActionService", new Class[0]);
                            Object navigatorActionService = getNavigatorActionServiceMethod.invoke((Object)commonNavigator, new Object[0]);
                            Field actionProviderInstancesField = navigatorActionService.getClass().getDeclaredField("actionProviderInstances");
                            actionProviderInstancesField.setAccessible(true);
                            HashMap object = (HashMap)actionProviderInstancesField.get(navigatorActionService);
                            if (object != null) {
                                for (Object value : object.values()) {
                                    IWorkingSet[] iWorkingSetArray;
                                    Class<?> theClass = value.getClass();
                                    if (!"org.eclipse.ui.internal.navigator.resources.actions.WorkingSetActionProvider".equals(theClass.getName())) continue;
                                    Field workingSetField = theClass.getDeclaredField("workingSet");
                                    workingSetField.setAccessible(true);
                                    IWorkingSet oldWorkingSet = (IWorkingSet)workingSetField.get(value);
                                    if (oldWorkingSet == null) {
                                        iWorkingSetArray = new IWorkingSet[]{};
                                    } else if (oldWorkingSet.isAggregateWorkingSet()) {
                                        iWorkingSetArray = ((IAggregateWorkingSet)oldWorkingSet).getComponents();
                                    } else {
                                        IWorkingSet[] iWorkingSetArray2 = new IWorkingSet[1];
                                        iWorkingSetArray = iWorkingSetArray2;
                                        iWorkingSetArray2[0] = oldWorkingSet;
                                    }
                                    IWorkingSet[] activeWorkingSets = iWorkingSetArray;
                                    LinkedHashSet<IWorkingSet> allWorkingSets = new LinkedHashSet<IWorkingSet>(Arrays.asList(activeWorkingSets));
                                    allWorkingSets.addAll(Arrays.asList(MANAGER.getAllWorkingSets()));
                                    List<IWorkingSet> newActiveWorkingSets = this.getActiveWorkingSets(allWorkingSets.toArray(new IWorkingSet[allWorkingSets.size()]), activeWorkingSets);
                                    StringBuilder id = new StringBuilder("Aggregate:");
                                    Iterator<IWorkingSet> it = newActiveWorkingSets.iterator();
                                    while (it.hasNext()) {
                                        IWorkingSet iWorkingSet = it.next();
                                        if (iWorkingSet == null) {
                                            it.remove();
                                            continue;
                                        }
                                        id.append(iWorkingSet.getName());
                                        id.append(":");
                                    }
                                    IWorkingSet aggregateWorkingSet = MANAGER.getWorkingSet(id.toString());
                                    if (aggregateWorkingSet == null) {
                                        aggregateWorkingSet = MANAGER.createAggregateWorkingSet(id.toString(), "Multiple Working Sets", newActiveWorkingSets.toArray(new IWorkingSet[newActiveWorkingSets.size()]));
                                        MANAGER.addWorkingSet(aggregateWorkingSet);
                                    }
                                    MANAGER.addRecentWorkingSet(aggregateWorkingSet);
                                    Method setWorkingSetMethod = theClass.getDeclaredMethod("setWorkingSet", IWorkingSet.class);
                                    setWorkingSetMethod.setAccessible(true);
                                    setWorkingSetMethod.invoke(value, aggregateWorkingSet);
                                }
                            }
                        }
                        if (!handledPackageExplorer && (packageExplorer = workbenchPage.findView(PACKAGE_EXPLORER_ID)) != null) {
                            handledPackageExplorer = true;
                            Class<?> packageExplorerClass = packageExplorer.getClass();
                            Method getWorkingSetModelMethod = packageExplorerClass.getMethod("getWorkingSetModel", new Class[0]);
                            Object workingSetModel = getWorkingSetModelMethod.invoke((Object)packageExplorer, new Object[0]);
                            if (workingSetModel != null) {
                                Class<?> workingSetModelClass = workingSetModel.getClass();
                                Method getAllWorkingSetsMethod = workingSetModelClass.getMethod("getAllWorkingSets", new Class[0]);
                                IWorkingSet[] allWorkingSets = (IWorkingSet[])getAllWorkingSetsMethod.invoke(workingSetModel, new Object[0]);
                                Method getActiveWorkingSetsMethod = workingSetModelClass.getMethod("getActiveWorkingSets", new Class[0]);
                                IWorkingSet[] activeWorkingSets = (IWorkingSet[])getActiveWorkingSetsMethod.invoke(workingSetModel, new Object[0]);
                                List<IWorkingSet> newActiveWorkingSets = this.getActiveWorkingSets(allWorkingSets, activeWorkingSets);
                                IWorkingSet[] orderedActiveWorkingSetsArray = newActiveWorkingSets.toArray(new IWorkingSet[newActiveWorkingSets.size()]);
                                Method setWorkingSetsMethod = workingSetModelClass.getMethod("setActiveWorkingSets", IWorkingSet[].class);
                                setWorkingSetsMethod.invoke(workingSetModel, new Object[]{orderedActiveWorkingSetsArray});
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (NoSuchMethodException ex) {
                WorkingSetsEditorPlugin.INSTANCE.log(ex);
            }
            catch (SecurityException ex) {
                WorkingSetsEditorPlugin.INSTANCE.log(ex);
            }
            catch (IllegalAccessException ex) {
                WorkingSetsEditorPlugin.INSTANCE.log(ex);
            }
            catch (InvocationTargetException ex) {
                WorkingSetsEditorPlugin.INSTANCE.log(ex);
            }
            catch (NoSuchFieldException ex) {
                WorkingSetsEditorPlugin.INSTANCE.log(ex);
            }
        }
    }

    private List<IWorkingSet> getActiveWorkingSets(IWorkingSet[] allWorkingSets, IWorkingSet[] activeWorkingSets) {
        ArrayList<IWorkingSet> newActiveWorkingSets;
        IWorkingSet iWorkingSet;
        HashMap<Iterator, IWorkingSet> managedWorkingSets = new HashMap<Iterator, IWorkingSet>();
        int i = 0;
        while (i < allWorkingSets.length) {
            IWorkingSet iWorkingSet2 = allWorkingSets[i];
            Iterator workingSet = this.workingSetGroup.getWorkingSet(iWorkingSet2.getName());
            if (workingSet != null) {
                managedWorkingSets.put(workingSet, iWorkingSet2);
            }
            ++i;
        }
        LinkedHashMap orderedWorkingSetGroups = new LinkedHashMap();
        for (WorkingSet workingSet : this.workingSetGroup.getWorkingSets()) {
            iWorkingSet = (IWorkingSet)managedWorkingSets.get(workingSet);
            ArrayList<IWorkingSet> group = new ArrayList<IWorkingSet>();
            group.add(iWorkingSet);
            orderedWorkingSetGroups.put(iWorkingSet, group);
        }
        List<Object> group = newActiveWorkingSets = new ArrayList<IWorkingSet>();
        IWorkingSet[] iWorkingSetArray = activeWorkingSets;
        int n = activeWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            iWorkingSet = iWorkingSetArray[n2];
            List targetGroup = (List)orderedWorkingSetGroups.get(iWorkingSet);
            if (targetGroup == null) {
                group.add(iWorkingSet);
            } else {
                group = targetGroup;
            }
            ++n2;
        }
        for (List workingSets : orderedWorkingSetGroups.values()) {
            newActiveWorkingSets.addAll(workingSets);
        }
        return newActiveWorkingSets;
    }

    private void updateProjects(final List<IProject> addedProjects, final List<IProject> removedProjects) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                EMap workingSets = WorkingSetManager.this.getWorkingSets();
                boolean isChanged = false;
                for (IProject project : addedProjects) {
                    if (!WorkingSetManager.this.addProject(project, (EMap<String, Set<IAdaptable>>)workingSets)) continue;
                    isChanged = true;
                }
                for (IProject project : removedProjects) {
                    if (!WorkingSetManager.this.removeProject(project, (EMap<String, Set<IAdaptable>>)workingSets)) continue;
                    isChanged = true;
                }
                if (isChanged) {
                    WorkingSetManager.this.apply((EMap<String, Set<IAdaptable>>)workingSets);
                }
            }
        });
    }

    private boolean updateProjects(EMap<String, Set<IAdaptable>> workingSets) {
        boolean result = false;
        IProject[] iProjectArray = WORKSPACE.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.addProject(project, workingSets)) {
                result = true;
            }
            ++n2;
        }
        return result;
    }

    private boolean addProject(IProject project, EMap<String, Set<IAdaptable>> workingSets) {
        boolean result = false;
        for (WorkingSet workingSet : this.workingSetGroup.getWorkingSets()) {
            if (!workingSet.matches((IResource)project)) continue;
            String name = workingSet.getName();
            LinkedHashSet<IProject> elements = (LinkedHashSet<IProject>)workingSets.get((Object)name);
            if (elements == null) {
                elements = new LinkedHashSet<IProject>();
                workingSets.put((Object)name, elements);
            }
            elements.add(project);
            result = true;
        }
        return result;
    }

    private boolean removeProject(IProject project, EMap<String, Set<IAdaptable>> workingSets) {
        boolean result = false;
        for (WorkingSet workingSet : this.workingSetGroup.getWorkingSets()) {
            String name;
            Set elements;
            if (!workingSet.matches((IResource)project) || (elements = (Set)workingSets.get((Object)(name = workingSet.getName()))) == null) continue;
            elements.remove(project);
            result = true;
        }
        return result;
    }

    public void apply() {
        String name;
        WorkingSetGroup oldWorkingSetGroup = this.workingSetGroup;
        this.workingSetGroup = WorkingSetsUtil.getWorkingSetGroup();
        BasicEMap workingSets = new BasicEMap();
        for (WorkingSet workingSet : oldWorkingSetGroup.getWorkingSets()) {
            name = workingSet.getName();
            workingSets.put((Object)name, null);
        }
        for (WorkingSet workingSet : this.workingSetGroup.getWorkingSets()) {
            name = workingSet.getName();
            workingSets.put((Object)name, new LinkedHashSet());
        }
        if (!workingSets.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable((EMap)workingSets){
                private final /* synthetic */ EMap val$workingSets;
                {
                    this.val$workingSets = eMap;
                }

                public void run() {
                    WorkingSetManager.this.updateProjects((EMap<String, Set<IAdaptable>>)this.val$workingSets);
                    WorkingSetManager.this.apply((EMap<String, Set<IAdaptable>>)this.val$workingSets);
                }
            });
        }
    }
}

