/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTreeWithoutWorkbench
extends FilteredTree {
    private final Object refreshJobFamily = new Object();
    private final ExpansionFilter expansionFilter;
    private int expansionCount;

    public FilteredTreeWithoutWorkbench(Composite parent, int style) {
        super(parent, style, new PatternFilter(), true);
        this.expansionFilter = null;
    }

    public FilteredTreeWithoutWorkbench(Composite parent, int style, PatternFilter patternFilter, ExpansionFilter expansionFilter) {
        super(parent, style, patternFilter, true);
        this.expansionFilter = expansionFilter;
    }

    public void setExpansionCount(int expansionCount) {
        this.expansionCount = expansionCount;
    }

    public Object getRefreshJobFamily() {
        return this.refreshJobFamily;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTreeWithoutWorkbench.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                PatternFilter patternFilter = FilteredTreeWithoutWorkbench.this.getPatternFilter();
                String text = FilteredTreeWithoutWorkbench.this.getFilterString();
                if (StringUtil.isEmpty((String)text)) {
                    patternFilter.setPattern(null);
                    FilteredTreeWithoutWorkbench.this.treeViewer.refresh(true);
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTreeWithoutWorkbench.this.initialText != null && FilteredTreeWithoutWorkbench.this.initialText.equals(text);
                if (initial) {
                    patternFilter.setPattern(null);
                } else {
                    patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = FilteredTreeWithoutWorkbench.this.treeComposite != null ? FilteredTreeWithoutWorkbench.this.treeComposite : FilteredTreeWithoutWorkbench.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    TreeItem[] is = FilteredTreeWithoutWorkbench.this.treeViewer.getTree().getItems();
                    int i = 0;
                    while (i < is.length) {
                        TreeItem item = is[i];
                        if (item.getExpanded()) {
                            FilteredTreeWithoutWorkbench.this.treeViewer.setExpandedState(item.getData(), false);
                        }
                        ++i;
                    }
                    FilteredTreeWithoutWorkbench.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0) {
                            int[] nArray = new int[1];
                            int n = nArray[0] = FilteredTreeWithoutWorkbench.this.expansionCount == 0 ? numVisibleItems : FilteredTreeWithoutWorkbench.this.expansionCount;
                            if (this.recursiveExpand(items, monitor, stopTime, nArray)) {
                                cancel = true;
                            }
                        }
                        FilteredTreeWithoutWorkbench.this.updateToolbar(true);
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTreeWithoutWorkbench.this.updateToolbar(false);
                    }
                    FilteredTreeWithoutWorkbench.this.refreshed();
                }
                finally {
                    TreeItem[] items = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTreeWithoutWorkbench.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTreeWithoutWorkbench.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null && (FilteredTreeWithoutWorkbench.this.expansionFilter == null || FilteredTreeWithoutWorkbench.this.expansionFilter.shouldExpand(itemData))) {
                            if (!item.getExpanded()) {
                                FilteredTreeWithoutWorkbench.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }

            public Display getDisplay() {
                return UIUtil.getDisplay();
            }

            public boolean shouldSchedule() {
                return true;
            }

            public boolean shouldRun() {
                return true;
            }

            public boolean belongsTo(Object family) {
                return family == FilteredTreeWithoutWorkbench.this.refreshJobFamily;
            }
        };
    }

    protected void refreshed() {
    }

    public static interface ExpansionFilter {
        public boolean shouldExpand(Object var1);
    }

    public static class WithCheckboxes
    extends FilteredTreeWithoutWorkbench {
        private static final Method CLEAR_CACHES_METHOD;

        static {
            Method clearCachesMethod = null;
            try {
                clearCachesMethod = ReflectUtil.getMethod(PatternFilter.class, (String)"clearCaches", (Class[])new Class[0]);
            }
            catch (Throwable throwable) {}
            CLEAR_CACHES_METHOD = clearCachesMethod;
        }

        public WithCheckboxes(Composite parent, int style, PatternFilter patternFilter, ExpansionFilter expansionFilter) {
            super(parent, style, patternFilter, expansionFilter);
        }

        public WithCheckboxes(Composite parent, int style) {
            super(parent, style);
        }

        public CheckboxTreeViewer getViewer() {
            return (CheckboxTreeViewer)super.getViewer();
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new NotifyingCheckboxTreeViewer(parent, style);
        }

        class NotifyingCheckboxTreeViewer
        extends CheckboxTreeViewer {
            public NotifyingCheckboxTreeViewer(Composite parent, int style) {
                super(parent, style);
            }

            public void add(Object parentElementOrTreePath, Object childElement) {
                this.clearPatternFilterCaches();
                super.add(parentElementOrTreePath, childElement);
            }

            public void add(Object parentElementOrTreePath, Object[] childElements) {
                this.clearPatternFilterCaches();
                super.add(parentElementOrTreePath, childElements);
            }

            public void insert(Object parentElementOrTreePath, Object element, int position) {
                this.clearPatternFilterCaches();
                super.insert(parentElementOrTreePath, element, position);
            }

            public void refresh() {
                this.clearPatternFilterCaches();
                super.refresh();
            }

            public void refresh(boolean updateLabels) {
                this.clearPatternFilterCaches();
                super.refresh(updateLabels);
            }

            public void refresh(Object element) {
                this.clearPatternFilterCaches();
                super.refresh(element);
            }

            public void refresh(Object element, boolean updateLabels) {
                this.clearPatternFilterCaches();
                super.refresh(element, updateLabels);
            }

            public void remove(Object elementsOrTreePaths) {
                this.clearPatternFilterCaches();
                super.remove(elementsOrTreePaths);
            }

            public void remove(Object parent, Object[] elements) {
                this.clearPatternFilterCaches();
                super.remove(parent, elements);
            }

            public void remove(Object[] elementsOrTreePaths) {
                this.clearPatternFilterCaches();
                super.remove(elementsOrTreePaths);
            }

            public void replace(Object parentElementOrTreePath, int index, Object element) {
                this.clearPatternFilterCaches();
                super.replace(parentElementOrTreePath, index, element);
            }

            public void setChildCount(Object elementOrTreePath, int count) {
                this.clearPatternFilterCaches();
                super.setChildCount(elementOrTreePath, count);
            }

            public void setContentProvider(IContentProvider provider) {
                this.clearPatternFilterCaches();
                super.setContentProvider(provider);
            }

            public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
                this.clearPatternFilterCaches();
                super.setHasChildren(elementOrTreePath, hasChildren);
            }

            protected void inputChanged(Object input, Object oldInput) {
                this.clearPatternFilterCaches();
                super.inputChanged(input, oldInput);
            }

            private void clearPatternFilterCaches() {
                if (CLEAR_CACHES_METHOD != null) {
                    try {
                        CLEAR_CACHES_METHOD.invoke((Object)WithCheckboxes.this.getPatternFilter(), new Object[0]);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

