/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.MTJNature;
import org.eclipse.mtj.internal.core.util.IJavaProjectVisitor;
import org.eclipse.mtj.internal.core.util.JavaProjectAdapter;
import org.eclipse.mtj.internal.jmunit.util.JMUnitTestsVisitor;

public class JMUnitNature
extends MTJNature {
    private static final String JMUNIT = "JMUnit";
    private static Map<IClasspathEntry, IPath[]> testExclusionPaths;

    public JMUnitNature() {
        if (testExclusionPaths == null) {
            testExclusionPaths = new HashMap<IClasspathEntry, IPath[]>();
        }
    }

    public void configure() throws CoreException {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        LinkedList<IClasspathEntry> linkedList = new LinkedList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        LinkedList<IClasspathEntry> linkedList2 = new LinkedList<IClasspathEntry>();
        for (IClasspathEntry iClasspathEntryArray2 : linkedList) {
            boolean bl = false;
            switch (iClasspathEntryArray2.getEntryKind()) {
                case 5: {
                    if (!iClasspathEntryArray2.getPath().toString().contains(JMUNIT)) break;
                    linkedList2.add(JavaCore.newContainerEntry((IPath)iClasspathEntryArray2.getPath(), (boolean)true));
                    bl = true;
                    break;
                }
                case 3: {
                    ArrayList<IPath> arrayList = new ArrayList<IPath>(Arrays.asList(iClasspathEntryArray2.getExclusionPatterns()));
                    IPath[] iPathArray = testExclusionPaths.get(iClasspathEntryArray2);
                    if (iPathArray != null) {
                        arrayList.removeAll(Arrays.asList(iPathArray));
                    }
                    linkedList2.add(JavaCore.newSourceEntry((IPath)iClasspathEntryArray2.getPath(), (IPath[])arrayList.toArray(new IPath[0])));
                    bl = true;
                }
            }
            if (bl) continue;
            linkedList2.add(iClasspathEntryArray2);
        }
        IClasspathEntry[] iClasspathEntryArray = linkedList2.toArray(new IClasspathEntry[linkedList.size()]);
        if (!iJavaProject.hasClasspathCycle(iClasspathEntryArray)) {
            iJavaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
            iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void deconfigure() throws CoreException {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        LinkedList<IClasspathEntry> linkedList = new LinkedList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        LinkedList<IClasspathEntry> linkedList2 = new LinkedList<IClasspathEntry>();
        JavaProjectAdapter javaProjectAdapter = new JavaProjectAdapter(iJavaProject);
        JMUnitTestsVisitor jMUnitTestsVisitor = new JMUnitTestsVisitor(iJavaProject);
        javaProjectAdapter.accept((IJavaProjectVisitor)jMUnitTestsVisitor);
        IPath[] iPathArray = jMUnitTestsVisitor.getJMunitTests();
        for (IClasspathEntry iClasspathEntryArray2 : linkedList) {
            boolean bl = false;
            switch (iClasspathEntryArray2.getEntryKind()) {
                case 5: {
                    if (!iClasspathEntryArray2.getPath().toString().contains(JMUNIT)) break;
                    linkedList2.add(JavaCore.newContainerEntry((IPath)iClasspathEntryArray2.getPath(), (boolean)false));
                    bl = true;
                    break;
                }
                case 3: {
                    IPath[] iPathArray2 = iClasspathEntryArray2.getExclusionPatterns();
                    ArrayList<IPath> arrayList = new ArrayList<IPath>();
                    arrayList.addAll(Arrays.asList(iPathArray2));
                    arrayList.addAll(Arrays.asList(iPathArray));
                    IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iClasspathEntryArray2.getPath(), (IPath[])arrayList.toArray(new IPath[0]));
                    linkedList2.add(iClasspathEntry);
                    if (iPathArray.length > 0) {
                        testExclusionPaths.put(iClasspathEntry, iPathArray);
                    }
                    bl = true;
                }
            }
            if (bl) continue;
            linkedList2.add(iClasspathEntryArray2);
        }
        IClasspathEntry[] iClasspathEntryArray = linkedList2.toArray(new IClasspathEntry[linkedList.size()]);
        if (!iJavaProject.hasClasspathCycle(iClasspathEntryArray)) {
            iJavaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
            iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

