/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.microemu;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.microemu.Activator;
import org.eclipse.mtj.internal.toolkit.microemu.Messages;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDevice;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDeviceSkin;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuLaunchTemplateProperties;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroEmuDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final MicroEmuDeviceSkin[] EMULATOR_DEVICE_SKINS = new MicroEmuDeviceSkin[]{new MicroEmuDeviceSkin("microemulator.jar", "org/microemu/device/default/device.xml", "Default device"), new MicroEmuDeviceSkin("devices/microemu-device-large.jar", "org/microemu/device/large/device.xml", "Large Device"), new MicroEmuDeviceSkin("devices/microemu-device-minimum.jar", "org/microemu/device/minimum/device.xml", "Minimum device")};
    private static final String EMULATOR_JAR_NAME = "microemulator.jar";
    private static final String MAIN_CLASS_NAME = "org.microemu.app.Main";
    private static final String PROPS_FILE = "microemu.properties";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<IMIDPDevice> arrayList = null;
        try {
            File file2 = new File(file, EMULATOR_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, MAIN_CLASS_NAME)) {
                arrayList = new ArrayList<IMIDPDevice>();
                MicroEmuDeviceSkin[] microEmuDeviceSkinArray = EMULATOR_DEVICE_SKINS;
                int n = EMULATOR_DEVICE_SKINS.length;
                int n2 = 0;
                while (n2 < n) {
                    MicroEmuDeviceSkin microEmuDeviceSkin = microEmuDeviceSkinArray[n2];
                    IMIDPDevice iMIDPDevice = this.createDevice(file2, microEmuDeviceSkin);
                    arrayList.add(iMIDPDevice);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            MTJLogger.log((int)2, (String)Messages.MicroEmuDeviceImporter_import_error, (Throwable)exception);
        }
        return arrayList;
    }

    private void addDeviceLibraries(File file, IDeviceClasspath iDeviceClasspath, ILibraryImporter iLibraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MicroEmuLaunchTemplateProperties.TOOLKITROOT.toString(), file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)iLibraryImporter.createLibraryFor(new File(string2));
            IMIDPAPI iMIDPAPI = iMIDPLibrary.getAPI(MIDPAPIType.UNKNOWN);
            if (iMIDPAPI != null) {
                if (iMIDPAPI.getIdentifier().equalsIgnoreCase("cldcapi11.jar")) {
                    iMIDPAPI.setIdentifier("CLDC");
                    iMIDPAPI.setType(MIDPAPIType.CONFIGURATION);
                    iMIDPAPI.setName("Connected Limited Device Configuration");
                    iMIDPAPI.setVersion(new Version("1.1"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("midpapi20.jar")) {
                    iMIDPAPI.setIdentifier("MIDP");
                    iMIDPAPI.setType(MIDPAPIType.PROFILE);
                    iMIDPAPI.setName("Mobile Information Device Profile");
                    iMIDPAPI.setVersion(new Version("2.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-jsr-75.jar")) {
                    iMIDPAPI.setIdentifier("JSR75");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("PDA Optional Packages for the J2ME Platform");
                    iMIDPAPI.setVersion(new Version("1.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-jsr-82.jar")) {
                    iMIDPAPI.setIdentifier("JSR82");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Java APIs for Bluetooth");
                    iMIDPAPI.setVersion(new Version("1.1"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-jsr-120.jar")) {
                    iMIDPAPI.setIdentifier("JSR120");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Wireless Messaging API");
                    iMIDPAPI.setVersion(new Version("1.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-jsr-135.jar")) {
                    iMIDPAPI.setIdentifier("JSR135");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Mobile Media API");
                    iMIDPAPI.setVersion(new Version("1.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-nokiaui.jar")) {
                    iMIDPAPI.setIdentifier("Nokia UI");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Nokia UI API");
                    iMIDPAPI.setVersion(new Version("1.1"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("microemu-siemensapi.jar")) {
                    iMIDPAPI.setIdentifier("Siemens API");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Siemens API");
                    iMIDPAPI.setVersion(new Version("1.0"));
                }
                iDeviceClasspath.addEntry((ILibrary)iMIDPLibrary);
            }
            ++n2;
        }
    }

    private IMIDPDevice createDevice(File file, MicroEmuDeviceSkin microEmuDeviceSkin) {
        MicroEmuDevice microEmuDevice = new MicroEmuDevice();
        microEmuDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        microEmuDevice.setClasspath(this.getDeviceClasspath(file));
        microEmuDevice.setDebugServer(this.isDebugServer());
        microEmuDevice.setDescription("Microemulator Device");
        microEmuDevice.setDeviceProperties(new Properties());
        microEmuDevice.setGroupName("Microemulator");
        microEmuDevice.setName(microEmuDeviceSkin.getName());
        microEmuDevice.setPreverifier(this.getPreverifier(file));
        microEmuDevice.setProtectionDomains(new String[0]);
        microEmuDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        microEmuDevice.setRoot(file.getParentFile());
        microEmuDevice.setSkin(microEmuDeviceSkin);
        ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)microEmuDevice);
        iSymbolSet.setName(microEmuDevice.getName());
        microEmuDevice.setSymbolSet(iSymbolSet);
        Version version = new Version(1, 0, 0);
        ISDK iSDK = BasicSDK.getSDK((String)"Microemulator", (Version)version);
        microEmuDevice.setSDK(iSDK);
        ((BasicSDK)iSDK).addDevice((IDevice)microEmuDevice);
        return microEmuDevice;
    }

    private IDeviceClasspath getDeviceClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        this.addDeviceLibraries(file, iDeviceClasspath, MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei"));
        return iDeviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

