/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.templates;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.templates.Messages;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplashApplicationWizardPage
extends AbstractTemplateWizardPage {
    private Text imageText;
    private Button size1;
    private Button size2;
    private Button size3;
    private Text colorText;
    private Text timeText;

    public void createControl(Composite composite) {
        GridData gridData = null;
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite, 0);
        group.setText(Messages.SplashTemplateProvider_0);
        gridData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.SplashTemplateProvider_1);
        gridData = new GridData(4);
        label.setLayoutData((Object)gridData);
        this.imageText = new Text((Composite)group, 2048);
        this.imageText.setText(Messages.SplashTemplateProvider_2);
        this.imageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.imageText.setLayoutData((Object)gridData);
        Group group2 = new Group((Composite)group, 0);
        group2.setText(Messages.SplashTemplateProvider_3);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        group2.setLayoutData((Object)gridData);
        group2.setLayout((Layout)new GridLayout(3, false));
        this.size1 = new Button((Composite)group2, 16);
        this.size1.setText("128 x 160");
        gridData = new GridData(768);
        this.size1.setLayoutData((Object)gridData);
        this.size1.setSelection(true);
        this.size2 = new Button((Composite)group2, 16);
        this.size2.setText("176 x 220");
        gridData = new GridData(768);
        this.size2.setLayoutData((Object)gridData);
        this.size3 = new Button((Composite)group2, 16);
        this.size3.setText("240 x 320");
        gridData = new GridData(768);
        this.size3.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(Messages.SplashTemplateProvider_7);
        gridData = new GridData(4);
        label2.setLayoutData((Object)gridData);
        this.colorText = new Text((Composite)group, 2048);
        this.colorText.setText("0xFFFFFF");
        this.colorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        this.colorText.setLayoutData((Object)gridData);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(Messages.SplashTemplateProvider_9);
        gridData = new GridData(4);
        label3.setLayoutData((Object)gridData);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(Messages.SplashTemplateProvider_10);
        gridData = new GridData(4);
        label4.setLayoutData((Object)gridData);
        this.timeText = new Text((Composite)group, 2048);
        this.timeText.setText("3000");
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SplashApplicationWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.timeText.setLayoutData((Object)gridData);
    }

    public Map<String, String> getDictionary() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$image-name$", this.imageText.getText());
        hashMap.put("$image-size$", this.getImageSize());
        hashMap.put("$splash-time$", this.timeText.getText());
        hashMap.put("$bg-color$", this.colorText.getText());
        return hashMap;
    }

    private String getImageSize() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.size1.getSelection()) {
            stringBuffer.append("_128x160");
        } else if (this.size2.getSelection()) {
            stringBuffer.append("_176x220");
        } else if (this.size3.getSelection()) {
            stringBuffer.append("_240x320");
        }
        return stringBuffer.toString();
    }

    public boolean isPageComplete() {
        boolean bl = true;
        bl &= Pattern.matches("(0x)([a-fA-F0-9]){6}", this.colorText.getText());
        bl &= Pattern.matches("\\d+", this.timeText.getText());
        return bl &= this.imageText.getText().length() > 0;
    }
}

