/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.projects;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.util.ExceptionHandler;
import org.eclipse.mtj.internal.ui.wizards.NewElementWizard;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageJavaSettings;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageLibrary;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.mtj.internal.ui.wizards.projects.NewMidletProjectWizardPageProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private IConfigurationElement configElement;
    private NewMidletProjectWizardPageOne firstPage;
    private NewMidletProjectWizardPageProperties propertiesPage;
    private NewMidletProjectWizardPageLibrary libraryPage;
    private NewMidletProjectWizardPageJavaSettings javaSettingsPage;
    private IWorkbench workbench;

    public NewMidletProjectWizard() {
        this(null, null, null, null);
    }

    public NewMidletProjectWizard(NewMidletProjectWizardPageOne newMidletProjectWizardPageOne, NewMidletProjectWizardPageProperties newMidletProjectWizardPageProperties, NewMidletProjectWizardPageJavaSettings newMidletProjectWizardPageJavaSettings, NewMidletProjectWizardPageLibrary newMidletProjectWizardPageLibrary) {
        ImageDescriptor imageDescriptor = MTJUIPluginImages.DESC_NEW_PROJECT;
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.setWindowTitle(MTJUIMessages.NewMidletProjectWizard_wizard_title);
        this.firstPage = newMidletProjectWizardPageOne;
        this.propertiesPage = newMidletProjectWizardPageProperties;
        this.javaSettingsPage = newMidletProjectWizardPageJavaSettings;
        this.libraryPage = newMidletProjectWizardPageLibrary;
    }

    public void addPages() {
        if (this.firstPage == null) {
            this.firstPage = new NewMidletProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.firstPage);
        if (this.propertiesPage == null) {
            this.propertiesPage = new NewMidletProjectWizardPageProperties(this.firstPage);
        }
        this.addPage((IWizardPage)this.propertiesPage);
        if (this.libraryPage == null) {
            this.libraryPage = new NewMidletProjectWizardPageLibrary();
        }
        if (this.libraryPage.isPageDisplayable()) {
            this.addPage((IWizardPage)this.libraryPage);
        }
        if (this.javaSettingsPage == null) {
            this.javaSettingsPage = new NewMidletProjectWizardPageJavaSettings(this.firstPage, this.propertiesPage, this.libraryPage);
        }
        this.addPage((IWizardPage)this.javaSettingsPage);
        this.firstPage.init(this.getSelection(), this.getActivePart());
    }

    public void createControl(Composite composite) {
    }

    public IJavaElement getCreatedElement() {
        return this.javaSettingsPage.getJavaProject();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.workbench = iWorkbench;
    }

    public boolean performCancel() {
        this.javaSettingsPage.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean bl = super.performFinish();
        if (bl) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            try {
                IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.javaSettingsPage.getJavaProject());
                IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
                if (iFile != null) {
                    BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
                    this.openResource(iFile);
                }
                MTJBuildProperties mTJBuildProperties = MTJBuildProperties.getBuildProperties((IMTJProject)iMidletSuiteProject);
                mTJBuildProperties.store();
            }
            catch (Throwable throwable) {
                MTJLogger.log((int)4, (String)MTJUIMessages.NewMidletProjectWizard_error_open_jad_file, (Throwable)throwable.getCause());
            }
        }
        return bl;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActivePart();
        }
        return null;
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        this.javaSettingsPage.performFinish(iProgressMonitor);
    }

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = MTJUIMessages.NewMidletProjectWizard_error_create_project_window_title;
        String string2 = MTJUIMessages.NewMidletProjectWizard_error_create_project_window_message;
        ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
    }
}

