/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.midlet.page;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewMidletWizardPage
extends NewTypeWizardPage {
    public static final String PAGE_NAME = "NewMidletClass";
    private static final String SETTINGS_ADD_TO_JAD = "addToJad";
    private static final String SETTINGS_CONSTRUCTORS = "constructors";
    private static final String SETTINGS_UNIMPLEMENTED = "unimplemented";
    private Button addToJadButton;
    private Button constructorsButton;
    private Button unimplementedButton;

    public NewMidletWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(MTJUIMessages.NewMidletWizardPage_title);
        this.setDescription(MTJUIMessages.NewMidletWizardPage_description);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createEnclosingTypeControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createModifierControls(composite2, n);
        this.createSuperClassControls(composite2, n);
        this.createSuperInterfacesControls(composite2, n);
        this.createMethodStubSelectionControls(composite2, n);
        this.createAddToJADSelectionControl(composite2, n);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        IDialogSettings iDialogSettings = this.getDialogSettings().getSection(PAGE_NAME);
        if (iDialogSettings != null) {
            bl = iDialogSettings.getBoolean(SETTINGS_ADD_TO_JAD);
            bl2 = iDialogSettings.getBoolean(SETTINGS_CONSTRUCTORS);
            bl3 = iDialogSettings.getBoolean(SETTINGS_UNIMPLEMENTED);
        }
        this.addToJadButton.setSelection(bl);
        this.constructorsButton.setSelection(bl2);
        this.unimplementedButton.setSelection(bl3);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public void init(IStructuredSelection iStructuredSelection) {
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        this.initTypePage(iJavaElement);
        this.setSuperClass("javax.microedition.midlet.MIDlet", true);
    }

    public boolean isAddToJadSelected() {
        return this.addToJadButton.getSelection();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setFocus();
        }
    }

    private void createAddToJADSelectionControl(Composite composite, int n) {
        new Label(composite, 0);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 1;
        composite2.setLayoutData((Object)gridData);
        this.addToJadButton = new Button(composite2, 32);
        this.addToJadButton.setText(MTJUIMessages.NewMidletWizardPage_add_to_jad_btn_text);
    }

    private void createMethodStubSelectionControls(Composite composite, int n) {
        new Label(composite, 0);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 1;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(MTJUIMessages.NewMidletWizardPage_which_methods);
        this.constructorsButton = new Button(composite2, 32);
        this.constructorsButton.setText(MTJUIMessages.NewMidletWizardPage_super_const);
        this.constructorsButton.setSelection(true);
        this.unimplementedButton = new Button(composite2, 32);
        this.unimplementedButton.setText(MTJUIMessages.NewMidletWizardPage_unimplemented);
        this.unimplementedButton.setSelection(true);
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(iStatusArray);
    }

    private IProject getContainedProject() {
        IProject iProject = null;
        String string = this.getPackageFragmentRootText();
        Path path = new Path(string);
        IResource iResource = this.getWorkspaceRoot().findMember((IPath)path);
        if (iResource != null) {
            iProject = iResource.getProject();
        }
        return iProject;
    }

    protected IStatus containerChanged() {
        int n;
        IStatus iStatus = super.containerChanged();
        String string = this.getPackageFragmentRootText();
        Path path = new Path(string);
        IResource iResource = this.getWorkspaceRoot().findMember((IPath)path);
        if (iResource != null && ((n = iResource.getType()) == 4 || n == 2)) {
            IProject iProject = iResource.getProject();
            try {
                if (!iProject.hasNature("org.eclipse.mtj.core.nature") && iResource.exists()) {
                    if (n == 4) {
                        return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotAMidletProject);
                    }
                    return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotInAMidletProject);
                }
            }
            catch (CoreException coreException) {
                return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_NotAMidletProject);
            }
        }
        return iStatus;
    }

    protected void createTypeMembers(IType iType, NewTypeWizardPage.ImportsManager importsManager, IProgressMonitor iProgressMonitor) throws CoreException {
        this.createInheritedMethods(iType, this.constructorsButton.getSelection(), this.unimplementedButton.getSelection(), importsManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(this.getDialogSettings(), PAGE_NAME);
        iDialogSettings.put(SETTINGS_ADD_TO_JAD, this.addToJadButton.getSelection());
        iDialogSettings.put(SETTINGS_CONSTRUCTORS, this.constructorsButton.getSelection());
        iDialogSettings.put(SETTINGS_UNIMPLEMENTED, this.unimplementedButton.getSelection());
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.doStatusUpdate();
    }

    protected IStatus superClassChanged() {
        IStatus iStatus = super.superClassChanged();
        boolean bl = false;
        String string = this.getSuperClass();
        IProject iProject = this.getContainedProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            if (iJavaProject != null) {
                bl = Utils.isMidlet((IType)iJavaProject.findType(string), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {}
        if (!bl) {
            return new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletWizardPage_warning_super_must_be_midlet);
        }
        return iStatus;
    }
}

