/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationData;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationWizardPage1;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class StringLocalizationWizard
extends Wizard {
    private StringLocalizationWizardPage1 page1;
    private ICompilationUnit target;
    private L10nModel model;

    public StringLocalizationWizard(ICompilationUnit iCompilationUnit, L10nModel l10nModel) {
        if (iCompilationUnit == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizard_classCanNotBeNull);
        }
        if (l10nModel == null) {
            throw new IllegalArgumentException(MTJUIMessages.StringLocalizationWizard_l10nModelCanNotBeNull);
        }
        this.target = iCompilationUnit;
        this.model = l10nModel;
        this.setWindowTitle(MTJUIMessages.StringLocalizationWizard_dialogTitle);
    }

    public boolean performFinish() {
        block4: {
            if (this.model.getLocales().getChildCount() != 0) break block4;
            return false;
        }
        try {
            StringLocalizationData[] stringLocalizationDataArray = this.page1.getExternalizedStrings();
            StringLocalizationData[] stringLocalizationDataArray2 = this.page1.getIgnoredStrings();
            if (stringLocalizationDataArray.length > 0 || stringLocalizationDataArray2.length > 0) {
                this.updateLocalizationData(this.model, stringLocalizationDataArray);
                this.updateClassFile(this.model, stringLocalizationDataArray, stringLocalizationDataArray2);
                return true;
            }
        }
        catch (Exception exception) {
            MTJLogger.log((int)4, (Throwable)exception);
        }
        return false;
    }

    private void updateClassFile(L10nModel l10nModel, StringLocalizationData[] stringLocalizationDataArray, StringLocalizationData[] stringLocalizationDataArray2) throws CoreException {
        IField iField;
        ReplaceEdit replaceEdit;
        String string;
        IRegion iRegion;
        StringLocalizationData stringLocalizationData;
        IImportDeclaration iImportDeclaration = null;
        String string2 = null;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        L10nLocales l10nLocales = l10nModel.getLocales();
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        StringLocalizationData[] stringLocalizationDataArray3 = stringLocalizationDataArray;
        int n = stringLocalizationDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringLocalizationData = stringLocalizationDataArray3[n2];
            iRegion = stringLocalizationData.getRegion();
            string = NLS.bind((String)"l10n.getString(L10nConstants.keys.{0})", (Object)stringLocalizationData.getKey().toUpperCase());
            replaceEdit = new ReplaceEdit(iRegion.getOffset(), iRegion.getLength(), string);
            multiTextEdit.addChild((TextEdit)replaceEdit);
            ++n2;
        }
        stringLocalizationDataArray3 = stringLocalizationDataArray2;
        n = stringLocalizationDataArray2.length;
        n2 = 0;
        while (n2 < n) {
            stringLocalizationData = stringLocalizationDataArray3[n2];
            iRegion = stringLocalizationData.getRegion();
            string = NLS.bind((String)"\"{0}\"{1}", (Object[])new String[]{stringLocalizationData.getValue(), "/**$NON-NLS**/"});
            replaceEdit = new ReplaceEdit(iRegion.getOffset(), iRegion.getLength(), string);
            multiTextEdit.addChild((TextEdit)replaceEdit);
            ++n2;
        }
        this.target.applyTextEdit((TextEdit)multiTextEdit, (IProgressMonitor)nullProgressMonitor);
        string2 = l10nLocales.getPackage();
        if (string2.length() > 0) {
            string2 = String.valueOf(string2) + ".";
        }
        if (!(iImportDeclaration = this.target.getImport(NLS.bind((String)"{0}L10nResources", (Object)string2))).exists()) {
            this.target.createImport(NLS.bind((String)"{0}L10nResources", (Object)string2), null, (IProgressMonitor)nullProgressMonitor);
        }
        if (!(iImportDeclaration = this.target.getImport(NLS.bind((String)"{0}L10nConstants", (Object)string2))).exists()) {
            this.target.createImport(NLS.bind((String)"{0}L10nConstants", (Object)string2), null, (IProgressMonitor)nullProgressMonitor);
        }
        if (!(iField = (stringLocalizationData = this.target.findPrimaryType()).getField("l10n")).exists()) {
            stringLocalizationData.createField("L10nResources l10n = L10nResources.getL10nResources(null);", null, true, (IProgressMonitor)nullProgressMonitor);
        }
        this.target.save((IProgressMonitor)nullProgressMonitor, true);
    }

    private void updateLocalizationData(L10nModel l10nModel, StringLocalizationData[] stringLocalizationDataArray) throws CoreException {
        IDocumentElementNode[] iDocumentElementNodeArray;
        L10nLocales l10nLocales = l10nModel.getLocales();
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = l10nLocales.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nLocale l10nLocale = (L10nLocale)iDocumentElementNode;
            StringLocalizationData[] stringLocalizationDataArray2 = stringLocalizationDataArray;
            int n3 = stringLocalizationDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                StringLocalizationData stringLocalizationData = stringLocalizationDataArray2[n4];
                L10nEntry l10nEntry = l10nLocale.getEntry(stringLocalizationData.getKey());
                if (l10nEntry == null) {
                    l10nEntry = new L10nEntry(l10nModel);
                    l10nEntry.setKey(stringLocalizationData.getKey());
                    l10nLocale.addChild((L10nObject)l10nEntry);
                }
                l10nEntry.setValue(stringLocalizationData.getValue());
                ++n4;
            }
            ++n2;
        }
        l10nModel.save();
        L10nApi.syncronizeApi((L10nModel)l10nModel);
    }

    public void addPages() {
        try {
            String string = this.target.getElementName();
            IBuffer iBuffer = this.target.getBuffer();
            this.page1 = new StringLocalizationWizardPage1(string, iBuffer);
            this.addPage((IWizardPage)this.page1);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }
}

