/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.eclipseme;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.internal.core.project.midp.MTJProjectConverter;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveFileManipulations;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.StatusUtil;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarEntry;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.eclipseme.ProjectImporterMessage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportEclipseMEProjectWizardPage
extends WizardPage
implements IOverwriteQuery {
    private static final String EclipseME_NATURE = "eclipseme.core.nature";
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String METADATA_FOLDER = ".metadata";
    private static String previouslyBrowsedArchive = "";
    private static String previouslyBrowsedDirectory = "";
    private static final String STORE_ARCHIVE_SELECTED = "EclipseMEProjectImportWizard.STORE_ARCHIVE_SELECTED";
    private Text archivePathField;
    private Button browseArchivesButton;
    private Button browseDirectoriesButton;
    private Text directoryPathField;
    private long lastModified;
    private String lastPath;
    private Button projectFromArchiveRadio;
    private Button projectFromDirectoryRadio;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private boolean showProjectInWorkspaceWorning = false;
    private ILeveledImportStructureProvider structureProvider;
    private IProject[] wsProjects;

    public ImportEclipseMEProjectWizardPage() {
        this("wizardExternalProjectsPage");
    }

    public ImportEclipseMEProjectWizardPage(String string) {
        super(string);
        this.setPageComplete(false);
        this.setTitle(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(composite2);
        this.createProjectsList(composite2);
        this.createOptionsArea(composite2);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite2);
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] objectArray = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask("", objectArray.length);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Object[] objectArray2 = objectArray;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray2[n2];
                        ImportEclipseMEProjectWizardPage.this.createExistingProject((ProjectRecord)object, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ++n2;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = ProjectImporterMessage.WizardExternalProjectImportPage_errorMessage;
            Object object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.mtj.ui", 1, string, throwable);
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)object);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        return true;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    public ProjectRecord[] getValidProjects() {
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        int n = 0;
        while (n < this.selectedProjects.length) {
            boolean bl;
            boolean bl2 = !this.isProjectInWorkspace(this.selectedProjects[n].getProjectName());
            boolean bl3 = this.isEclipseMEProject(this.selectedProjects[n]);
            if (bl2 && bl3) {
                arrayList.add(this.selectedProjects[n]);
            }
            boolean bl4 = bl = !bl2;
            if (bl && bl3) {
                this.showProjectInWorkspaceWorning = true;
            }
            ++n;
        }
        return arrayList.toArray(new ProjectRecord[arrayList.size()]);
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    public String queryOverwrite(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_existsQuestion, (Object)string) : NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), ProjectImporterMessage.Question, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] stringArray = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                messageDialog.open();
            }
        });
        return messageDialog.getReturnCode() < 0 ? "CANCEL" : stringArray[messageDialog.getReturnCode()];
    }

    public void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            boolean bl = iDialogSettings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!bl);
            this.projectFromArchiveRadio.setSelection(bl);
            if (bl) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (bl && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String string) {
        if (string == null || string.length() == 0) {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = string;
            return;
        }
        final File file = new File(string);
        long l = file.lastModified();
        if (string.equals(this.lastPath) && this.lastModified == l) {
            return;
        }
        this.lastPath = string;
        this.lastModified = l;
        final boolean bl = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_SearchingMessage, 100);
                    ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList arrayList = new ArrayList();
                    iProgressMonitor.worked(10);
                    if (!bl && ArchiveFileManipulations.isTarFile(string)) {
                        TarFile tarFile = ImportEclipseMEProjectWizardPage.this.getSpecifiedTarSourceFile(string);
                        if (tarFile == null) {
                            return;
                        }
                        ImportEclipseMEProjectWizardPage.this.structureProvider = new TarLeveledStructureProvider(tarFile);
                        Object object = ImportEclipseMEProjectWizardPage.this.structureProvider.getRoot();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[arrayList.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[n++] = (ProjectRecord)iterator.next();
                        }
                    } else if (!bl && ArchiveFileManipulations.isZipFile(string)) {
                        ZipFile zipFile = ImportEclipseMEProjectWizardPage.this.getSpecifiedZipSourceFile(string);
                        if (zipFile == null) {
                            return;
                        }
                        ImportEclipseMEProjectWizardPage.this.structureProvider = new ZipLeveledStructureProvider(zipFile);
                        Object object = ImportEclipseMEProjectWizardPage.this.structureProvider.getRoot();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[arrayList.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[n++] = (ProjectRecord)iterator.next();
                        }
                    } else if (bl && file.isDirectory()) {
                        ArrayList arrayList2 = new ArrayList();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromDirectory(arrayList2, file, null, iProgressMonitor)) {
                            return;
                        }
                        Iterator iterator = arrayList2.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[arrayList2.size()];
                        int n = 0;
                        iProgressMonitor.worked(50);
                        iProgressMonitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (iterator.hasNext()) {
                            File file2 = (File)iterator.next();
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[n] = new ProjectRecord(file2);
                            ++n;
                        }
                    } else {
                        iProgressMonitor.worked(60);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJLogger.log((int)4, (String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.getValidProjects());
        if (this.showProjectInWorkspaceWorning) {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
        }
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> collection, File file, Set<String> set, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)file.getPath()));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        if (set == null) {
            set = new HashSet<String>();
            try {
                set.add(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, iOException.getLocalizedMessage(), iOException));
            }
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (file2.isFile() && file2.getName().equals(".project")) {
                collection.add(file2);
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < fileArray.length) {
            block12: {
                if (fileArray[n3].isDirectory() && !fileArray[n3].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String string = fileArray[n3].getCanonicalPath();
                            if (set.add(string)) break block11;
                            break block12;
                        }
                        catch (IOException iOException) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, iOException.getLocalizedMessage(), iOException));
                        }
                    }
                    this.collectProjectFilesFromDirectory(collection, fileArray[n3], set, iProgressMonitor);
                }
            }
            ++n3;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection<ProjectRecord> collection, Object object, int n, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(object)));
        ArrayList arrayList = this.structureProvider.getChildren(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        for (Object e : arrayList) {
            String string;
            if (this.structureProvider.isFolder(e)) {
                this.collectProjectFilesFromProvider(collection, e, n + 1, iProgressMonitor);
            }
            if (!(string = this.structureProvider.getLabel(e)).equals(".project")) continue;
            collection.add(new ProjectRecord(e, object, n));
        }
        return true;
    }

    private boolean createExistingProject(ProjectRecord projectRecord, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        Object object;
        Object object2;
        String string = projectRecord.getProjectName();
        IWorkspace iWorkspace = MTJCore.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string);
        if (!this.isEclipseMEProject(projectRecord)) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardProjectsImportPage_NotEclipseMEProject_Title, NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_NotEclipseMEProject_Message, (Object)string));
            return false;
        }
        if (projectRecord.description == null) {
            projectRecord.description = iWorkspace.newProjectDescription(string);
            object2 = new Path(projectRecord.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)object2)) {
                projectRecord.description.setLocation(null);
            } else {
                projectRecord.description.setLocation((IPath)object2);
            }
        } else {
            projectRecord.description.setName(string);
        }
        if (projectRecord.projectArchiveFile != null) {
            object2 = this.structureProvider.getChildren(projectRecord.parent);
            this.structureProvider.setStrip(projectRecord.level);
            ImportOperation importOperation = new ImportOperation(iProject.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, (List)object2);
            importOperation.setContext(this.getShell());
            importOperation.run(iProgressMonitor);
            try {
                MTJProjectConverter.getInstance().convertEclipseMeProject(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                return true;
            }
            catch (ProjectConvertionException projectConvertionException) {
                throw new InvocationTargetException(projectConvertionException);
            }
        }
        object2 = null;
        URI uRI = projectRecord.description.getLocationURI();
        if (uRI != null) {
            object2 = new File(uRI);
            object = iWorkspace.newProjectDescription(string);
            object.setBuildSpec(projectRecord.description.getBuildSpec());
            object.setComment(projectRecord.description.getComment());
            object.setDynamicReferences(projectRecord.description.getDynamicReferences());
            object.setNatureIds(projectRecord.description.getNatureIds());
            object.setReferencedProjects(projectRecord.description.getReferencedProjects());
            projectRecord.description = object;
        }
        try {
            iProgressMonitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_CreateProjectsTask, 100);
            iProject.create(projectRecord.description, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
        if (object2 != null) {
            object = FileSystemStructureProvider.INSTANCE.getChildren(object2);
            ImportOperation importOperation = new ImportOperation(iProject.getFullPath(), object2, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, (List)object);
            importOperation.setContext(this.getShell());
            importOperation.setOverwriteResources(true);
            importOperation.setCreateContainerStructure(false);
            importOperation.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
            try {
                MTJProjectConverter.getInstance().convertEclipseMeProject(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
            }
            catch (ProjectConvertionException projectConvertionException) {
                throw new InvocationTargetException(projectConvertionException);
            }
        }
        return true;
    }

    private void createOptionsArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
    }

    private void createProjectsList(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(ProjectImporterMessage.WizardProjectsImportPage_ProjectsListTitle);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(composite2, 2048);
        GridData gridData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object object) {
                return null;
            }

            public Object[] getElements(Object object) {
                return ImportEclipseMEProjectWizardPage.this.getValidProjects();
            }

            public Object getParent(Object object) {
                return null;
            }

            public boolean hasChildren(Object object) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((ProjectRecord)object).getProjectLabel();
            }
        });
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ImportEclipseMEProjectWizardPage.this.setPageComplete(ImportEclipseMEProjectWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(composite2);
    }

    private void createProjectsRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(composite2, 16);
        this.projectFromDirectoryRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(composite2, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(composite2, 8);
        this.browseDirectoriesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(composite2, 16);
        this.projectFromArchiveRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(composite2, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(composite2, 8);
        this.browseArchivesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.archiveRadioSelected();
            }
        });
    }

    private void createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(2));
        Button button = new Button(composite2, 8);
        button.setText(ProjectImporterMessage.DataTransfer_selectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.projectsList.setCheckedElements((Object[])ImportEclipseMEProjectWizardPage.this.selectedProjects);
                ImportEclipseMEProjectWizardPage.this.setPageComplete(ImportEclipseMEProjectWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite2, 8);
        button2.setText(ProjectImporterMessage.DataTransfer_deselectAll);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportEclipseMEProjectWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ImportEclipseMEProjectWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)button2);
        this.setButtonLayoutData(button2);
        Button button3 = new Button(composite2, 8);
        button3.setText(ProjectImporterMessage.DataTransfer_refresh);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImportEclipseMEProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
                } else {
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)button3);
        this.setButtonLayoutData(button3);
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
        }
    }

    private void displayErrorMessageDialog(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ImportEclipseMEProjectWizardPage.this.getShell(), (String)string, (String)string2);
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = MTJCore.getWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    private TarFile getSpecifiedTarSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new TarFile(string);
        }
        catch (TarException tarException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private ZipFile getSpecifiedZipSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(string);
        }
        catch (ZipException zipException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean isEclipseMEProject(ProjectRecord projectRecord) {
        return projectRecord.description.hasNature(EclipseME_NATURE);
    }

    private boolean isProjectInWorkspace(String string) {
        IProject[] iProjectArray;
        if (string == null) {
            return false;
        }
        IProject[] iProjectArray2 = iProjectArray = this.getProjectsInWorkspace();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (string.equals(iProject.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void handleLocationArchiveButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.archivePathField.getShell());
        fileDialog.setFilterExtensions(FILE_IMPORT_MASK);
        fileDialog.setText(ProjectImporterMessage.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String string = this.archivePathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedArchive;
        }
        if (string.length() == 0) {
            fileDialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string).getParentFile();
            if (object != null && ((File)object).exists()) {
                fileDialog.setFilterPath(((File)object).toString());
            }
        }
        object = fileDialog.open();
        if (object != null) {
            previouslyBrowsedArchive = object;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList((String)object);
        }
    }

    protected void handleLocationDirectoryButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.directoryPathField.getShell());
        directoryDialog.setMessage(ProjectImporterMessage.WizardProjectsImportPage_SelectDialogTitle);
        String string = this.directoryPathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedDirectory;
        }
        if (string.length() == 0) {
            directoryDialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                directoryDialog.setFilterPath(new Path(string).toOSString());
            }
        }
        object = directoryDialog.open();
        if (object != null) {
            previouslyBrowsedDirectory = object;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList((String)object);
        }
    }

    public class ProjectRecord {
        IProjectDescription description;
        int level;
        Object parent;
        Object projectArchiveFile;
        String projectName;
        File projectSystemFile;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object object, Object object2, int n) {
            this.projectArchiveFile = object;
            this.parent = object2;
            this.level = n;
            this.setProjectName();
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String string = this.projectSystemFile == null ? ImportEclipseMEProjectWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)string);
        }

        public String getProjectName() {
            return this.projectName;
        }

        private boolean isDefaultLocation(IPath iPath) {
            if (iPath.segmentCount() < 2) {
                return false;
            }
            return iPath.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        private void setProjectName() {
            try {
                InputStream inputStream;
                if (this.projectArchiveFile != null) {
                    inputStream = ImportEclipseMEProjectWizardPage.this.structureProvider.getContents(this.projectArchiveFile);
                    if (inputStream == null) {
                        if (this.projectArchiveFile instanceof ZipEntry) {
                            Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        } else if (this.projectArchiveFile instanceof TarEntry) {
                            Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        }
                    } else {
                        this.description = MTJCore.getWorkspace().loadProjectDescription(inputStream);
                        inputStream.close();
                        this.projectName = this.description.getName();
                    }
                }
                if (this.projectName == null) {
                    inputStream = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)inputStream)) {
                        this.projectName = inputStream.segment(inputStream.segmentCount() - 2);
                        this.description = MTJCore.getWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = MTJCore.getWorkspace().loadProjectDescription((IPath)inputStream);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }
}

