/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ArchiveFileManipulations {
    public static boolean isTarFile(String string) {
        block18: {
            if (string.length() == 0) {
                return false;
            }
            TarFile tarFile = null;
            try {
                tarFile = new TarFile(string);
            }
            catch (TarException tarException) {
                if (tarFile != null) {
                    try {
                        tarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            catch (IOException iOException) {
                block17: {
                    try {
                        if (tarFile == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (tarFile != null) {
                            try {
                                tarFile.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        tarFile.close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }
            if (tarFile == null) break block18;
            try {
                tarFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static boolean isZipFile(String string) {
        if (string.length() == 0) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(string);
            }
            catch (IOException iOException) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void closeStructureProvider(ILeveledImportStructureProvider iLeveledImportStructureProvider, Shell shell) {
        if (iLeveledImportStructureProvider instanceof ZipLeveledStructureProvider) {
            ArchiveFileManipulations.closeZipFile(((ZipLeveledStructureProvider)iLeveledImportStructureProvider).getZipFile(), shell);
        }
        if (iLeveledImportStructureProvider instanceof TarLeveledStructureProvider) {
            ArchiveFileManipulations.closeTarFile(((TarLeveledStructureProvider)iLeveledImportStructureProvider).getTarFile(), shell);
        }
    }

    public static boolean closeZipFile(ZipFile zipFile, Shell shell) {
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)ProjectImporterMessage.ZipImport_couldNotClose, (Object)zipFile.getName()), shell);
            return false;
        }
        return true;
    }

    public static boolean closeTarFile(TarFile tarFile, Shell shell) {
        try {
            tarFile.close();
        }
        catch (IOException iOException) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)ProjectImporterMessage.ZipImport_couldNotClose, (Object)tarFile.getName()), shell);
            return false;
        }
        return true;
    }

    protected static void displayErrorDialog(final String string, final Shell shell) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)ArchiveFileManipulations.getErrorDialogTitle(), (String)string);
            }
        };
        shell.getDisplay().syncExec(runnable);
    }

    protected static String getErrorDialogTitle() {
        return ProjectImporterMessage.WizardImportPage_internalErrorTitle;
    }
}

