/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.JavaSourceViewer;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.template.SimpleJavaSourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private Shell fShell;
    private StyledText fText;
    private Font fTextFont;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private final int fOrientation;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;

    public SourceViewerInformationControl(Shell shell, boolean bl, int n, String string) {
        Assert.isLegal((n == 0x4000000 || n == 0x2000000 || n == 0 ? 1 : 0) != 0);
        this.fOrientation = n;
        int n2 = 0x4004 | n | (bl ? 16 : 0);
        int n3 = bl ? 768 : 0;
        this.fShell = new Shell(shell, 0x84000 | n2);
        Display display = this.fShell.getDisplay();
        this.initializeColors();
        Shell shell2 = this.fShell;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        shell2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        shell2.setLayoutData((Object)gridData);
        if (string != null) {
            shell2 = new Composite((Composite)shell2, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 1;
            shell2.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            shell2.setLayoutData((Object)gridData);
            shell2.setForeground(display.getSystemColor(28));
            shell2.setBackground(this.fBackgroundColor);
        }
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        if ((n3 & 0x4000000) == 0 && (n3 & 0x2000000) == 0) {
            n3 |= 0x2000000;
        }
        this.fViewer = new JavaSourceViewer((Composite)shell2, null, null, false, n3, iPreferenceStore);
        this.fViewer.configure((SourceViewerConfiguration)new SimpleJavaSourceViewerConfiguration(JavaUI.getColorManager(), iPreferenceStore, null, "___java_partitioning", false));
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gridData = new GridData(1809);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (string != null) {
            FontData fontData;
            FontData[] fontDataArray;
            this.fSeparator = new Label((Composite)shell2, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)shell2, 131072);
            this.fStatusField.setText(string);
            Font font = this.fStatusField.getFont();
            FontData[] fontDataArray2 = fontDataArray = font.getFontData();
            int n4 = fontDataArray.length;
            int n5 = 0;
            while (n5 < n4) {
                fontData = fontDataArray2[n5];
                fontData.setHeight(fontData.getHeight() * 9 / 10);
                ++n5;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDataArray);
            this.fStatusField.setFont(this.fStatusTextFont);
            fontData = new GridData(770);
            this.fStatusField.setLayoutData((Object)fontData);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(this.fBackgroundColor);
        }
        this.addDisposeListener(this);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fText.addFocusListener(focusListener);
    }

    private void addInternalTrim(Rectangle rectangle) {
        Rectangle rectangle2 = this.fText.computeTrim(0, 0, 0, 0);
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        rectangle.width += rectangle2.width;
        rectangle.height += rectangle2.height;
        if (this.fStatusField != null) {
            rectangle.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            rectangle.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
            ++rectangle.height;
        }
    }

    public Point computeSizeConstraints(int n, int n2) {
        GC gC = new GC((Drawable)this.fText);
        gC.setFont(this.fTextFont);
        int n3 = gC.getFontMetrics().getAverageCharWidth();
        int n4 = gC.getFontMetrics().getHeight();
        gC.dispose();
        return new Point(n * n3, n2 * n4);
    }

    public Point computeSizeHint() {
        int n = -1;
        int n2 = -1;
        Point point = this.fShell.computeSize(n, n2);
        if (point.x > this.fMaxWidth) {
            n = this.fMaxWidth;
        }
        if (point.y > this.fMaxHeight) {
            n2 = this.fMaxHeight;
        }
        if (n != -1 || n2 != -1) {
            point = this.fShell.computeSize(n, n2, false);
        }
        return point;
    }

    public Rectangle computeTrim() {
        Rectangle rectangle = this.fShell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(rectangle);
        return rectangle;
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    private RGB getHoverBackgroundColorRGB() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        return iPreferenceStore.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"sourceHoverBackgroundColor");
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell, true, SourceViewerInformationControl.this.fOrientation, null);
            }
        };
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    private void initializeColors() {
        RGB rGB = this.getHoverBackgroundColorRGB();
        if (rGB != null) {
            this.fBackgroundColor = new Color((Device)this.fShell.getDisplay(), rGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.fShell.getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    private void initializeFont() {
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(this.fTextFont);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fText.removeFocusListener(focusListener);
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void setBackgroundColor(Color color) {
        this.fText.setBackground(color);
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void setForegroundColor(Color color) {
        this.fText.setForeground(color);
    }

    public void setInformation(String string) {
        if (string == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document document = new Document(string);
        new JavaTextTools(PreferenceConstants.getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences()).setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fViewer.setInput((Object)document);
    }

    public void setInput(Object object) {
        if (object instanceof String) {
            this.setInformation((String)object);
        } else {
            this.setInformation(null);
        }
    }

    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    public void setSize(int n, int n2) {
        this.fShell.setSize(n, n2);
    }

    public void setSizeConstraints(int n, int n2) {
        this.fMaxWidth = n;
        this.fMaxHeight = n2;
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        this.fTextFont = null;
        this.fShell = null;
        this.fText = null;
    }
}

