/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NonJavaLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection iSelection, String string) {
        List<ILaunchConfiguration> list = null;
        list = this.getLaunchConfigurations(iSelection);
        this.doLaunch(list, string);
    }

    public void launch(IEditorPart iEditorPart, String string) {
        List<ILaunchConfiguration> list = null;
        list = this.getLaunchConfigurations(iEditorPart);
        this.doLaunch(list, string);
    }

    private void doLaunch(List<ILaunchConfiguration> list, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n < 1) {
            iLaunchConfiguration = this.createConfiguration();
        } else if (n == 1) {
            iLaunchConfiguration = list.get(0);
        } else {
            ILaunchConfiguration iLaunchConfiguration2 = this.chooseConfiguration(list);
            if (iLaunchConfiguration2 != null) {
                iLaunchConfiguration = iLaunchConfiguration2;
            }
        }
        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
    }

    protected abstract List<ILaunchConfiguration> getLaunchConfigurations(ISelection var1);

    protected abstract List<ILaunchConfiguration> getLaunchConfigurations(IEditorPart var1);

    protected abstract ILaunchConfiguration createConfiguration();

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(MTJUIMessages.launch_configSelection_title);
        elementListSelectionDialog.setMessage(MTJUIMessages.launch_configSelection_message);
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow iWorkbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            shell = iWorkbenchWindow.getShell();
        }
        return shell;
    }
}

