/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.ArrayList;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonBarBlock {
    public static final int BUTTON_ADD = 2;
    public static final int BUTTON_ADD_INDEX = 0;
    public static final int BUTTON_DOWN = 16;
    public static final int BUTTON_DOWN_INDEX = 3;
    public static final int BUTTON_REMOVE = 4;
    public static final int BUTTON_REMOVE_INDEX = 1;
    public static final int BUTTON_UP = 8;
    public static final int BUTTON_UP_INDEX = 2;
    public static final int BUTTON_SCAN = 32;
    public static final int BUTTON_SCAN_INDEX = 4;
    public static final int BUTTON_ALL = 62;
    private ArrayList<Button> buttons;

    public ButtonBarBlock(Composite composite, FormToolkit formToolkit, int n) {
        this.initialize(composite, formToolkit, n);
    }

    public ButtonBarBlock(Composite composite, int n) {
        this.initialize(composite, n);
    }

    public void addButtonListener(int n, int n2, Listener listener) {
        this.buttons.get(n).addListener(n2, listener);
    }

    public Button getButton(int n) {
        return this.buttons.get(n);
    }

    public boolean isButtonEnabled(int n) {
        return this.buttons.get(n).isEnabled();
    }

    public void setButtonMouseListener(int n, MouseListener mouseListener) {
        this.buttons.get(n).addMouseListener(mouseListener);
    }

    public void setEnabled(int n, boolean bl) {
        this.buttons.get(n).setEnabled(bl);
    }

    private void initialize(Composite composite, FormToolkit formToolkit, int n) {
        Button button;
        this.buttons = new ArrayList(4);
        if ((n & 2) != 0) {
            button = formToolkit.createButton(composite, MTJUIMessages.buttonBarBlock_button_add, 8);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 4) != 0) {
            button = formToolkit.createButton(composite, MTJUIMessages.buttonBarBlock_button_remove, 8);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 8) != 0) {
            button = formToolkit.createButton(composite, MTJUIMessages.buttonBarBlock_button_up, 8);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 0x10) != 0) {
            button = formToolkit.createButton(composite, MTJUIMessages.buttonBarBlock_button_down, 8);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 0x20) != 0) {
            button = formToolkit.createButton(composite, MTJUIMessages.ButtonBarBlock_Scan, 8);
            button.setEnabled(false);
            this.buttons.add(button);
        }
    }

    private void initialize(Composite composite, int n) {
        Button button;
        this.buttons = new ArrayList(4);
        if ((n & 2) != 0) {
            button = new Button(composite, 8);
            button.setText(MTJUIMessages.buttonBarBlock_button_add);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 4) != 0) {
            button = new Button(composite, 8);
            button.setText(MTJUIMessages.buttonBarBlock_button_remove);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 8) != 0) {
            button = new Button(composite, 8);
            button.setText(MTJUIMessages.buttonBarBlock_button_up);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 0x10) != 0) {
            button = new Button(composite, 8);
            button.setText(MTJUIMessages.buttonBarBlock_button_down);
            button.setEnabled(false);
            this.buttons.add(button);
        }
        if ((n & 0x20) != 0) {
            button = new Button(composite, 8);
            button.setText(MTJUIMessages.ButtonBarBlock_Scan);
            button.setEnabled(false);
            this.buttons.add(button);
        }
    }

    public void setEnabled(boolean bl) {
        for (Button button : this.buttons) {
            button.setEnabled(bl);
        }
    }
}

